/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.messagingconnector;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * 
 * This class is the action used by the messaging connector plugin.
 * It uses the correct mail server component.
 *
 */
public class SetPasswordAction extends ServiceableAction
{
    /** The password in the request */
    private static final String PASSWORD_FIELD = "password";

    /** The current user provider */
    protected CurrentUserProvider _currentUserProvider;

    private MessagingConnector _messagingConnector;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _currentUserProvider = (CurrentUserProvider) smanager.lookup(CurrentUserProvider.ROLE);
        _messagingConnector = (MessagingConnector) smanager.lookup(MessagingConnector.ROLE);
    }

    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws UserPreferencesException, MessagingConnectorException
    {
        Map<String, Object> result = new HashMap<>();
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        UserIdentity identity = _currentUserProvider.getUser();
        if (identity != null)
        {
            String password = request.getParameter(PASSWORD_FIELD);
            if (!StringUtils.isBlank(password))
            {
                _messagingConnector.setUserPassword(identity, password);
                result.put("success", true);
            }
            else
            {
                result.put("success", false);
                result.put("error", "password-empty");
                I18nizableText message = new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_ERROR_INPUT_PASSWORD_EMPTY");
                result.put("message", message);
            }
        }

        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }
    
}
