/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.messagingconnector;

/**
 * This class represents a mail. A mail is composed by:<br>
 * - a sender (name or email)<br>
 * - a subject<br>
 * - a summary<br>
 */
public class EmailMessage
{
    /** Sender of the mail */
    private String _sender;

    /** Subject of the mail */
    private String _subject;

    /** Summary of the mail */
    private String _summary;

    /** 
     * Creates a empty email
     */
    public EmailMessage()
    {
       // Nothing
    }
    
    /**
     * Creates a new mail message
     * @param subject the subject of the mail
     * @param sender the sender of the mail
     * @param summary the summary/body of the mail
     */
    public EmailMessage(String subject, String sender, String summary)
    {
        this._subject = subject;
        this._sender = sender;
        this._summary = summary;
    }

    /**
     * Get the sender of the mail
     * @return the sender
     */
    public String getSender()
    {
        return _sender;
    }

    /**
     * Set the sender of the mail to a new user
     * @param sender the sender to set
     */
    public void setSender(String sender)
    {
        this._sender = sender;
    }

    /**
     * Get the subject of the mail
     * @return the subject
     */
    public String getSubject()
    {
        return _subject;
    }

    /**
     * Set the subject of the mail to a new value
     * @param subject the subject to set
     */
    public void setSubject(String subject)
    {
        this._subject = subject;
    }

    /**
     * Get the summary of the mail
     * @return the summary
     */
    public String getSummary()
    {
        return _summary;
    }

    /**
     * Set the content of the mail to a new summary
     * @param summary the summary to set
     */
    public void setSummary(String summary)
    {
        this._summary = summary;
    }

    @Override
    public String toString()
    {
        return "MailMessage [_subject=" + _subject + ", _sender=" + _sender + ", _summary=" + _summary + "]";
    }

}
