<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:math="java.lang.Math"
    exclude-result-prefixes="ametys math">
    
	<xsl:template name="script-js-messaging-connector">
	    <xsl:param name="max-days">7</xsl:param>
        <xsl:param name="max-events">1</xsl:param>
	    <xsl:param name="email-none"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_NONE" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
	    <xsl:param name="email-single"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_SINGLE" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
	    <xsl:param name="email-several"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_SEVERAL" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="css-class-prefix">messaging</xsl:param>
	    <xsl:param name="connector"/>
        <xsl:param name="uniqueId" select="concat('messaging-connector_', substring-after(math:random(), '.'))"/>
	   
    	<script type="text/javascript">
           var messagingConnectorTimeoutId;
           var messagingConnectorTimeoutCurrentDuration = 30 * 1000;//Timeout to set in case of timeout error (in ms)
            
            function updateMessagingConnector() {
                function updateData(data)
                {
                    if (data)
                    {
                        if (data.success == false)
                        {
                            switch (data.error)
                            {
                                case "UNAUTHORIZED":
                                    function insertChangePasswordLink()
                                    {
                                        var $email = $j('.<xsl:value-of select="$css-class-prefix"/>-user-infos-mail');
                                        if ($email.length > 0)
                                        {
                                            MessagingConnector.insertChangePasswordLink('email-user-infos-error-change-password', updateMessagingConnector);
                                        }
                                        
                                        var $agenda = $j('.<xsl:value-of select="$css-class-prefix"/>-user-infos-agenda');
                                        if ($agenda.length > 0)
                                        {
                                            MessagingConnector.insertChangePasswordLink('agenda-user-infos-error-change-password', updateMessagingConnector);
                                        }
                                    }
                                    
                                    // Load js to change password if not yet loaded
                                    if (!window.MessagingConnector || !MessagingConnector.insertChangePasswordLink)
                                    {
                                        MessagingConnector = {SITE_URI_PREFIX: '<xsl:value-of select="ametys:siteUriPrefix()"/>', LANG: '<xsl:value-of select="ametys:lang()"/>'};
                                        
                                        $j.getScript("<xsl:value-of select="ametys:uriPrefix()"/>/plugins/messaging-connector/resources/js/messaging-connector-password.js")
                                        .done(function(){
                                            // Insert change password link for agenda/mail if exist
                                            insertChangePasswordLink();
                                        })
                                        .fail(function(jqxhr, settings, exception) { console.error("An error occurred while loading js files", exception); });
                                    }
                                    else
                                    {
                                        // Insert change password link for agenda/mail if exist
                                        insertChangePasswordLink();
                                    }
                                    clearTimeout(messagingConnectorTimeoutId);//no more calls
                                    break;
                                case "CONFIGURATION_EXCEPTION":
                                    clearTimeout(messagingConnectorTimeoutId);//no more calls
                                    break;
                                case "TIMEOUT":
                                    var maxTimeout = <xsl:value-of select="ametys:config('org.ametys.plugins.messagingconnector.cache.ttl')" /> * 60 * 1000;
                                    if (maxTimeout == 0)
                                    {
                                        maxTimeout = 60 * 1000;
                                    }
                                    clearTimeout(messagingConnectorTimeoutId);
                                    messagingConnectorTimeoutId = setTimeout(updateMessagingConnector, messagingConnectorTimeoutCurrentDuration);
                                    if (messagingConnectorTimeoutCurrentDuration * 2 >= maxTimeout)
                                    {
                                        messagingConnectorTimeoutCurrentDuration = maxTimeout;
                                    }
                                    else
                                    {
                                        messagingConnectorTimeoutCurrentDuration = messagingConnectorTimeoutCurrentDuration * 2;
                                    }
                                    break;
                                case "UNKNOWN":
                                default:
                                    //No changes
                                    break;
                            }
                        }
                    }
                    
                    // This function must be called once dom is ready.
                    <xsl:call-template name="script-js-update-email">
                         <xsl:with-param name="email-none"><xsl:copy-of select="$email-none"/></xsl:with-param>
                         <xsl:with-param name="email-single"><xsl:copy-of select="$email-single"/></xsl:with-param>
                         <xsl:with-param name="email-several"><xsl:copy-of select="$email-several"/></xsl:with-param>
                         <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="script-js-update-agenda">
                        <xsl:with-param name="max-days"><xsl:copy-of select="$max-days"/></xsl:with-param>
                        <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
                    </xsl:call-template>
                }
                
                $j.ajax({
                    url: '<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/messaging-connector/collect-info',
                    method: 'POST',
                    data: {
                    	maxDays: <xsl:value-of select="$max-days"/>,
                    	maxEvents: <xsl:value-of select="$max-events"/>,
                    	lang: '<xsl:value-of select="ametys:lang()"/>'
                    },
                    cache: false,
                    dataType: 'json',
                    success: function(data) {
                        $j(document).ready(function() {
                            updateData(data);
                        });
                    },
                    error: function() {
                        $j(document).ready(function() {
                            updateData();
                        });
                    },
                    complete: function() {
                        var timeout = <xsl:value-of select="ametys:config('org.ametys.plugins.messagingconnector.cache.ttl')" /> * 60 * 1000;
                        if (timeout &lt;= 0)
                        {
                            timeout = 60 * 1000;
                        }
                        messagingConnectorTimeoutId = setTimeout(updateMessagingConnector, timeout);
                    }
                });
            };
            updateMessagingConnector();
		</script>
	</xsl:template>
    
	<xsl:template name="script-js-update-email">
	    <xsl:param name="email-none"/>
	    <xsl:param name="email-single"/>
	    <xsl:param name="email-several"/>
	    <xsl:param name="css-class-prefix"/>
	    var $email = $j('.<xsl:value-of select="$css-class-prefix"/>-user-infos-mail'),
	        text;
                        
	    // Emails (hide waiting text, display data or error text)
        $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-waiting').hide();
        $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error').hide();
        $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').hide();
        $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-change-password').hide();
        $email.find('.<xsl:value-of select="$css-class-prefix"/>-change-password-link').hide();

        var $emailInfo = $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-info'),
            $emailLink = $j('#<xsl:value-of select="$css-class-prefix"/>-nb-msg');
        $emailInfo.hide();
        $emailLink.hide();
        
        if (data &amp;&amp; data.success &amp;&amp; data.unreadMessages &gt;= 0)
        {
            if (data.unreadMessages &lt;= 0) text = "<xsl:copy-of select='$email-none'/>";
            else if (data.unreadMessages == 1) text = data.unreadMessages + ' ' + "<xsl:copy-of select='$email-single'/>";
            else text = data.unreadMessages + ' ' + "<xsl:copy-of select='$email-several'/>";
            
            $emailLink.text(text);
            $emailLink.show();
            $emailInfo.show();
        }
        else if (data &amp;&amp; data.success == false &amp;&amp; data.message)
        {
            $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').text(data.message);
            $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').show();
            if (data.error == "UNAUTHORIZED")
            {
                $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-change-password').show();
                $email.find('.<xsl:value-of select="$css-class-prefix"/>-change-password-link').show();
            }
        }
        else
        {
            $email.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error').show();
        }
	</xsl:template>
	
	<xsl:template name="script-js-update-agenda">
	    <xsl:param name="max-days"/>
	    <xsl:param name="css-class-prefix"/>
	    var $agenda = $j('.<xsl:value-of select="$css-class-prefix"/>-user-infos-agenda');
	    
	    // Agenda (hide waiting text, display data or error text)
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-waiting').hide();
        // Hide each fields to re-display the ones that will be displayed on this update
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-events').hide();
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-noevent').hide();
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error').hide();
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').hide();
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-change-password').hide();
        $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-change-password-link').hide();
        
        if (data &amp;&amp; data.success &amp;&amp; data.events &amp;&amp; data.events.length &gt; 0)
        {
            var $listEvents = $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-events'),
                <xsl:variable name="event-html"><xsl:call-template name="agenda-event"><xsl:with-param name="css-class-prefix" select="$css-class-prefix"/></xsl:call-template></xsl:variable>
                html = '<xsl:copy-of select="normalize-space($event-html)"/>';
            $listEvents.empty();
                
            data.events.forEach(function(event) {
               $listEvents.append(html);
               var $event = $listEvents.children().last();
               if (event.eventSubject)
               {
                   $event.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-title').text(event.eventSubject);
               }
               else
               {
                   $event.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-title').next('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-separator').hide(); // hide the separator after the subject as it is empty
               }
               $event.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-date').text(event.eventStartDateFormatted);
               if (event.eventLocation)
               {
                   $event.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-location').text(event.eventLocation);
               }
               else
               {
                   $event.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-location').prev('.<xsl:value-of select="$css-class-prefix"/>-user-infos-event-separator').hide(); // hide the separator before location as it is empty
               }
            });
            $listEvents.show();
        }
        else if (data &amp;&amp; data.success &amp;&amp; data.events)
        {
            $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-maxdays').text('<xsl:copy-of select='$max-days'/>');
            $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-noevent').show();
        }
        else if (data &amp;&amp; data.success == false &amp;&amp; data.message)
        {
            $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').text(data.message);
            $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-server').show();
            if (data.error == "UNAUTHORIZED")
            {
                $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error-change-password').show();
                $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-change-password-link').show();
            }
        }
        else
        {
            $agenda.find('.<xsl:value-of select="$css-class-prefix"/>-user-infos-error').show();
        }
	</xsl:template>
	
	<xsl:template name="agenda-event">
	   <xsl:param name="css-class-prefix"/>
	    &lt;li class="user-infos-event <xsl:value-of select="$css-class-prefix"/>-user-infos-event">
			<xsl:call-template name="messaging-event-subject">
			     <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
			</xsl:call-template>
			<xsl:call-template name="messaging-event-separator">
			 <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
			</xsl:call-template>
			<xsl:call-template name="messaging-event-date">
			     <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
			</xsl:call-template>
			<xsl:call-template name="messaging-event-separator">
			     <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
			</xsl:call-template>
			<xsl:call-template name="messaging-event-location">
			     <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
			</xsl:call-template>
		&lt;/li>
	</xsl:template>
	
	<xsl:template name="messaging-event-separator"><xsl:param name="css-class-prefix"/>&lt;span class="user-infos-event-separator <xsl:value-of select="$css-class-prefix"/>-user-infos-event-separator">&lt;/span></xsl:template>
	
	<xsl:template name="messaging-event-subject"><xsl:param name="css-class-prefix"/>&lt;span class="user-infos-event-title <xsl:value-of select="$css-class-prefix"/>-user-infos-event-title"/></xsl:template>
	
	<xsl:template name="messaging-event-date"><xsl:param name="css-class-prefix"/>&lt;span class="user-infos-event-date <xsl:value-of select="$css-class-prefix"/>-user-infos-event-date"/></xsl:template>
	
	<xsl:template name="messaging-event-location"><xsl:param name="css-class-prefix"/>&lt;span class="user-infos-event-location <xsl:value-of select="$css-class-prefix"/>-user-infos-event-location"/></xsl:template>
</xsl:stylesheet>
