/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector.dynamic;

import java.util.Map;
import org.ametys.plugins.linkdirectory.dynamic.AbstractInternalDynamicInformationGenerator;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractMessagingConnectorDynamicInformationGenerator
extends AbstractInternalDynamicInformationGenerator {
    protected MessagingConnector _messagingConnector;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._messagingConnector = (MessagingConnector)this.manager.lookup(MessagingConnector.ROLE);
    }

    protected void saxError(DynamicInformationException e) throws SAXException {
        if (e.getType() == DynamicInformationException.ExceptionType.UNAUTHORIZED && this._messagingConnector.supportUserCredential(this.getCurrentUser())) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("type", e.getType().name());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"error", (Attributes)attr);
            I18nizableText errorMessage = new I18nizableText("plugin.link-directory", "PLUGINS_LINKDIRECTORY_DYNAMIC_INFO_PROVIDER_ERROR_" + DynamicInformationException.ExceptionType.UNAUTHORIZED.name());
            errorMessage.toSAX(this.contentHandler);
            String spanId = this.getSpanId();
            attr.clear();
            attr.addCDATAAttribute("id", spanId);
            attr.addCDATAAttribute("class", "link-change-password-link");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"span", (Attributes)attr);
            attr.clear();
            attr.addCDATAAttribute("type", "text/javascript");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"script", (Attributes)attr);
            XMLUtils.data((ContentHandler)this.contentHandler, (String)this._scriptToUpdatePassword(spanId));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"script");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"error");
        } else {
            super.saxError(e);
        }
    }

    protected abstract String getSpanId();

    private String _scriptToUpdatePassword(String spanId) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String uriPrefix = AmetysXSLTHelper.uriPrefix();
        String siteUriPrefix = AmetysXSLTHelper.siteUriPrefix();
        String lang = request.getParameter("lang");
        String uniqueId = request.getParameter("uniqueId");
        return "if (!window.MessagingConnector || !MessagingConnector.insertChangePasswordLink)\n{\n" + String.format("\tMessagingConnector = {SITE_URI_PREFIX: '%s', LANG: '%s'}\n", siteUriPrefix, lang) + String.format("\t$j.getScript(\"%s/plugins/messaging-connector/resources/js/messaging-connector-password.js\")", uriPrefix, lang) + String.format(".done(function(){MessagingConnector.insertChangePasswordLink('%s', updateDynamicInformation_%s)})", spanId, uniqueId) + ".fail(function(jqxhr, settings, exception) { console.error(\"An error occurred while loading js files\", exception); })\n}\nelse{\n" + String.format("\tMessagingConnector.insertChangePasswordLink('%s', updateDynamicInformation_%s)\n", spanId, uniqueId) + "}\n";
    }
}

