/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.messagingconnector;

import java.util.Date;

/***
 * 
 * This class represents an event from a calendar.
 * An event is represented with :<br> 
 * - a title<br>
 * - a start date<br> 
 * - a end date (optional)<br> 
 * - a location (optional)
 */
public class CalendarEvent
{
    /** Date of the beginning of the event */
    private Date _startDate;

    /** Date of the end of the event */
    private Date _endDate;

    /** Title of the event */
    private String _title;

    /** Location of the event */
    private String _location;

    /**
     * Creates a empty calendar event
     */
    public CalendarEvent()
    {
        // Nothing
    }
    
    /**
     * Creates a new calendar event
     * @param dateStart the date when the event starts
     * @param dateEnd the date when the event ends
     * @param title the title of the event
     * @param location the location of the event
     */
    public CalendarEvent(Date dateStart, Date dateEnd, String title, String location)
    {
        this._startDate = dateStart;
        this._endDate = dateEnd;
        this._title = title;
        this._location = location;
    }

    /**
     * Get the start date of the event
     * @return the start date
     */
    public Date getStartDate()
    {
        return _startDate;
    }

    /**
     * Set the start date of the event
     * @param startDate the start date
     */
    public void setStartDate(Date startDate)
    {
        this._startDate = startDate;
    }

    /**
     * Get the end date of the event
     * @return the end date
     */
    public Date getEndDate()
    {
        return _endDate;
    }

    /**
     * Set the end date of the event to a new Date
     * @param endDate the end date to set
     */
    public void setEndDate(Date endDate)
    {
        this._endDate = endDate;
    }

    /**
     * Get the subject of the event
     * @return the subject of the event 
     */
    public String getSubject()
    {
        return _title;
    }

    /**
     * Set the title of the event
     * @param title the title to set
     */
    public void setSubject(String title)
    {
        this._title = title;
    }

    /**
     * Get the location of the event
     * @return the location
     */
    public String getLocation()
    {
        return _location;
    }

    /**
     * Set the location of the event
     * @param location the location to set
     */
    public void setLocation(String location)
    {
        this._location = location;
    }

    @Override
    public String toString()
    {
        return "CalendarEvent [_startDate=" + _startDate + ", _endDate=" + _endDate + ", _subject=" + _title + ", _location=" + _location + "]";
    }
}
