/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.EmailMessage;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.apache.avalon.framework.component.Component;

public interface MessagingConnector
extends Component {
    public static final String ROLE = MessagingConnector.class.getName();

    public List<String> getAllowedPopulationIds() throws MessagingConnectorException;

    public List<CalendarEvent> getEvents(UserIdentity var1, int var2, int var3) throws MessagingConnectorException;

    public int getEventsCount(UserIdentity var1, int var2) throws MessagingConnectorException;

    public List<EmailMessage> getUnreadEmails(UserIdentity var1, int var2) throws MessagingConnectorException;

    public int getUnreadEmailCount(UserIdentity var1) throws MessagingConnectorException;

    public boolean supportInvitation() throws MessagingConnectorException;

    public boolean isEventExist(String var1, UserIdentity var2) throws MessagingConnectorException;

    public String createEvent(String var1, String var2, String var3, boolean var4, ZonedDateTime var5, ZonedDateTime var6, EventRecurrenceTypeEnum var7, ZonedDateTime var8, Map<String, Boolean> var9, UserIdentity var10) throws MessagingConnectorException;

    public void updateEvent(String var1, String var2, String var3, String var4, boolean var5, ZonedDateTime var6, ZonedDateTime var7, EventRecurrenceTypeEnum var8, ZonedDateTime var9, Map<String, Boolean> var10, UserIdentity var11) throws MessagingConnectorException;

    public void deleteEvent(String var1, UserIdentity var2) throws MessagingConnectorException;

    public Map<String, AttendeeInformation> getAttendees(String var1, UserIdentity var2) throws MessagingConnectorException;

    public void setAttendees(String var1, Map<String, Boolean> var2, UserIdentity var3) throws MessagingConnectorException;

    public Map<String, FreeBusyStatus> getFreeBusy(Date var1, Date var2, boolean var3, Set<String> var4, UserIdentity var5) throws MessagingConnectorException;

    public boolean isUserExist(UserIdentity var1) throws MessagingConnectorException;

    public boolean userCredentialNeeded(UserIdentity var1);

    public boolean supportUserCredential(UserIdentity var1);

    public void setUserPassword(UserIdentity var1, String var2) throws UserPreferencesException, MessagingConnectorException;

    public static class AttendeeInformation {
        private boolean _mandatory;
        private ResponseType _responseType;

        public AttendeeInformation(boolean mandatory, ResponseType responseType) {
            this._mandatory = mandatory;
            this._responseType = responseType;
        }

        public boolean isMandatory() {
            return this._mandatory;
        }

        public ResponseType getResponseType() {
            return this._responseType;
        }
    }

    public static enum ResponseType {
        Accept,
        Decline,
        Maybe,
        Unknown;

    }

    public static enum FreeBusyStatus {
        Busy,
        Free,
        Unknown;

    }
}

