<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
        
    <xsl:template match="/ActionResult">
        <html>
	        <script type="text/template" id="messaging-change-password-link-template">
	            <xsl:call-template name="messaging-connector-change-password-link"/>
	        </script>
	        
	        <xsl:call-template name="messaging-connector-change-password-dialog"/>
        </html>
    </xsl:template>
    
    <xsl:template name="messaging-connector-change-password-link">
        <a class="messaging-change-password-link" title="plugin.messaging-connector:PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_LINK_TITLE" i18n:attr="title" href="javascript:void(0)">
            <i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_LINK_TEXT" i18n:catalogue="plugin.messaging-connector"/>
        </a>
    </xsl:template>
    
    <!-- +
         | Template for the HTML of dialog box to change password.
         | The id of global div have to be 'messaging-change-password-dialog'.
         | The dialog box should contain a input of type 'password' and a element with css class 'messaging-change-password-error' to display server errors.
         + -->
    <xsl:template name="messaging-connector-change-password-dialog">
        <div id="messaging-change-password-dialog" class="messaging-change-password-dialog" style="display: none;" title="plugin.messaging-connector:PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_TITLE" i18n:attr="title">
            <div class="messaging-change-password-text"><i18n:text i18n:catalogue="plugin.messaging-connector" i18n:key="PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_TEXT"/></div>
            
            <div class="messaging-change-password-field">
                <div class="messaging-change-password-label">
                    <label for="password-field"><i18n:text i18n:catalogue="plugin.messaging-connector" i18n:key="PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_FIELD_LABEL"/></label>
                </div>
                <div class="messaging-change-password-input">
                    <input type="password" id="password-field" i18n:attr="placeholder" placeholder="plugin.messaging-connector:PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_PLACEHOLDER"/>
                </div>
            </div>
            
            <div class="messaging-change-password-error" style="display: none;"><!-- This must be empty and will contain the server message --></div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>