/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class MessagingConnectorAction
extends ServiceableAction {
    protected static final Map<Locale, DateFormat> __DATETIME_FORMATS = new HashMap<Locale, DateFormat>();
    protected static final Map<Locale, DateFormat> __TIME_FORMATS = new HashMap<Locale, DateFormat>();
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE d MMM H'h'mm");
    private static final String MAX_DAYS = "maxDays";
    private static final String MAX_EVENTS = "maxEvents";
    protected String _mailServerId;
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _usersManager;
    protected MessagingConnector _messagingConnector;
    protected org.ametys.core.util.I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._messagingConnector = (MessagingConnector)smanager.lookup(MessagingConnector.ROLE);
        this._usersManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._i18nUtils = (org.ametys.core.util.I18nUtils)smanager.lookup(org.ametys.core.util.I18nUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Boolean success = true;
        try {
            UserIdentity identity = this._currentUserProvider.getUser();
            if (identity != null) {
                result.put("unreadMessages", this._messagingConnector.getUnreadEmailCount(identity));
                int maxDays = Integer.parseInt(request.getParameter(MAX_DAYS));
                int maxEvents = Integer.parseInt(request.getParameter(MAX_EVENTS));
                List<CalendarEvent> nextEvents = this._messagingConnector.getEvents(identity, maxDays, maxEvents);
                result.put("events", this.eventsToJson(nextEvents, this.getLocale(request, objectModel)));
                result.put("nbNextEvents", this._messagingConnector.getEventsCount(identity, maxDays));
            }
        }
        catch (MessagingConnectorException e) {
            success = false;
            MessagingConnectorException.ExceptionType type = e.getType();
            switch (type) {
                case TIMEOUT: 
                case UNAUTHORIZED: 
                case CONFIGURATION_EXCEPTION: {
                    result.put("error", type.name());
                    I18nizableText errorMessage = new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_ERROR_" + type.name().toUpperCase());
                    result.put("message", errorMessage);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        result.put("success", success);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Locale getLocale(Request request, Map objectModel) {
        String lang = request.getParameter("lang");
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            return LocaleUtils.toLocale((String)lang);
        }
        return I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
    }

    protected List<Map<String, Object>> eventsToJson(List<CalendarEvent> events, Locale locale) {
        ArrayList<Map<String, Object>> eventsDisplayed = new ArrayList<Map<String, Object>>();
        for (CalendarEvent event : events) {
            HashMap<String, String> eventDisplayed = new HashMap<String, String>();
            eventDisplayed.put("eventStartDateFormatted", this._getFormattedDate(event.getStartDate(), locale));
            eventDisplayed.put("eventEndDateFormatted", this._getFormattedDate(event.getEndDate(), locale));
            eventDisplayed.put("eventLocation", event.getLocation());
            eventDisplayed.put("eventSubject", event.getSubject());
            eventsDisplayed.add(eventDisplayed);
        }
        return eventsDisplayed;
    }

    protected String _getFormattedDate(Date date, Locale locale) {
        boolean isSameDay = DateUtils.isSameDay((Date)date, (Date)new Date());
        Map<Locale, DateFormat> dateFormats = isSameDay ? __TIME_FORMATS : __DATETIME_FORMATS;
        DateFormat df = dateFormats.get(locale);
        if (df == null) {
            String key = isSameDay ? "PLUGINS_MESSAGINGCONNECTOR_RDV_TIME_FORMAT" : "PLUGINS_MESSAGINGCONNECTOR_RDV_DATETIME_FORMAT";
            String strFormat = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.messaging-connector", key), locale.toString());
            df = new SimpleDateFormat(strFormat, locale);
            dateFormats.put(locale, df);
        }
        return df.format(date);
    }
}

