/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.site;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.plugins.site.token.GetToken;

/**
 * Handle token for mobileapp requests.
 */
public class MobileappToken implements GetToken
{
    /** Regexp for webdav uri */
    public static final Pattern MOBILEAPP_URI_PATTERN = Pattern.compile("(?:.*/)?_plugins/mobileapp/[0-9.]+/([^/]+)/(.+)");
    
    public String getToken(Request request)
    {
        String uri = request.getSitemapURI();
        
        Matcher matcher = MOBILEAPP_URI_PATTERN.matcher(uri);
        if (matcher.matches())
        {
            String token = request.getHeader(AuthenticateAction.HEADER_TOKEN);
            if (StringUtils.isBlank(token))
            {
                token = request.getParameter(AuthenticateAction.REQUEST_PARAMETER_TOKEN);
            }
            return token;
        }
        
        return null;
    }

    public String getTokenContext(Request request)
    {
        String uri = request.getSitemapURI();
        
        Matcher matcher = MOBILEAPP_URI_PATTERN.matcher(uri);
        if (matcher.matches())
        {
            return "mobileapp";
        }
        return null;
    }
}
