/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.site;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.site.token.GetToken;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class MobileappToken
implements GetToken {
    public static final Pattern MOBILEAPP_URI_PATTERN = Pattern.compile("(?:.*/)?_plugins/mobileapp/[0-9.]+/([^/]+)/(.+)");

    public String getToken(Request request) {
        String uri = request.getSitemapURI();
        Matcher matcher = MOBILEAPP_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String token = request.getHeader("X-Ametys-Token");
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
            return token;
        }
        return null;
    }

    public String getTokenContext(Request request) {
        String uri = request.getSitemapURI();
        Matcher matcher = MOBILEAPP_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            return "mobileapp";
        }
        return null;
    }
}

