/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.site;

import java.util.List;
import org.ametys.plugins.site.proxy.BackOfficeRequestProxy;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class OIDCSessionAttributeRequestProxy
implements BackOfficeRequestProxy {
    public static final String HEADER_PREFIX = "X-Ametys-Mobile-";
    private static final List<String> __ATTRIBUTES = List.of("oidc_token", "msal_token");

    public void prepareBackOfficeRequest(Request request, HttpUriRequest backOfficeRequest) {
        Session session = request.getSession(false);
        if (session != null) {
            for (String attributeName : __ATTRIBUTES) {
                Object attribute = session.getAttribute(attributeName);
                if (attribute == null && (attribute = request.getHeader(HEADER_PREFIX + attributeName)) != null) {
                    session.setAttribute(attributeName, attribute);
                }
                if (attribute == null) continue;
                backOfficeRequest.setHeader("X-Ametys-Session-" + attributeName, attribute.toString());
            }
        }
    }

    public void handleBackOfficeResponse(Response response, HttpResponse backOfficeResponse) {
    }
}

