/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

/**
 * Returns the latest version compatible between client and server
 */
public class LatestVersionAction extends AbstractPostAction
{
    /** Application current version */
    protected static final int _CURRENT_VERSION = 1;

    /** Parameter containing the client version */
    protected static final String _CLIENT_VERSION = "app_version";

    @Override
    protected Map<String, Object> doAction(Request request, Map<String, Object> jsonParams)
    {
        Map<String, Object> result = new HashMap<>();
        String clientVersionString = (String) getParameter(_CLIENT_VERSION, jsonParams, request);

        int clientVersion = 1;

        if (StringUtils.isNotBlank(clientVersionString))
        {
            clientVersion = Integer.parseInt(clientVersionString);
        }

        int communicationVersion = _CURRENT_VERSION;
        if (clientVersion < _CURRENT_VERSION)
        {
            communicationVersion = clientVersion;
        }

        result.put("code", 200);
        result.put("server_version", communicationVersion);

        return result;
    }

}
