/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.mobileapp.action.AbstractLoggedAction;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

public class GetProjectsAction
extends AbstractLoggedAction {
    private ProjectsCatalogueManager _projectsCatalogueManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        if (PluginsManager.getInstance().isPluginActive("workspaces")) {
            this._projectsCatalogueManager = (ProjectsCatalogueManager)smanager.lookup(ProjectsCatalogueManager.ROLE);
        }
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this._projectsCatalogueManager != null) {
            List userProjects = this._projectsCatalogueManager.getUserProjects();
            List<Map> feedList = userProjects.stream().map(up -> this._mapResult((Map<String, Object>)up)).sorted(Comparator.comparing(project -> ((String)project.get("name")).toLowerCase())).toList();
            result.put("feed_list", feedList);
        }
        return result;
    }

    private Map<String, Object> _mapResult(Map<String, Object> userProject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("feed_id", userProject.get("id"));
        result.put("name", userProject.get("title"));
        result.put("url", userProject.get("url"));
        result.put("illustration", userProject.get("illustration"));
        result.put("language", userProject.get("language"));
        if (userProject.containsKey("category")) {
            result.put("color", ((Map)userProject.get("category")).get("color"));
        }
        return result;
    }
}

