/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.mobileapp.PostConstants;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;

/**
 * Returns the notifications settings for a user
 */
public class GetNotificationsPrefsAction extends AbstractLoggedAction
{
    /** User Preferences Helper */
    protected UserPreferencesHelper _userPreferencesHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _userPreferencesHelper = (UserPreferencesHelper) smanager.lookup(UserPreferencesHelper.ROLE);
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams)
    {
        String pushToken = (String) getParameter(PostConstants.NOTIF_TOKEN, jsonParams, request);

        UserIdentity user = _currentUserProvider.getUser();
        Map<String, Object> notificationSettings = _userPreferencesHelper.getNotificationSettings(pushToken, user);

        return notificationSettings;
    }
}
