/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceResolver;

import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;

/**
 * Authenticates a user based on login and password form parameters.
 */
public class GetTokenFromFormAction extends AbstractGetTokenAction
{
    private SourceResolver _sourceResolver;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _sourceResolver = (SourceResolver) smanager.lookup(SourceResolver.class.getName());
    }

    @Override
    protected UserIdentity tryConnect(Map<String, Object> params, Request request, String context, UserPopulation userPopulation, CredentialProvider credentialProvider, int credentialProviderIndex)
    {
        if (credentialProvider instanceof FormCredentialProvider)
        {
            try
            {
                String login = (String) getParameter("login", params, request);
                String password = (String) getParameter("password", params, request);
                
                request.setAttribute(AuthenticateAction.REQUEST_ATTRIBUTE_AUTHENTICATED, "false");
                
                String loginParameters = "Username=" + URIUtils.encodeParameter(login);
                loginParameters += "&Password=" + URIUtils.encodeParameter(password);
                loginParameters += "&UserPopulation=" + URIUtils.encodeParameter(userPopulation.getId());
                loginParameters += "&CredentialProviderIndex=" + credentialProviderIndex;
                loginParameters += "&context=" + URIUtils.encodeParameter(context);

                _sourceResolver.resolveURI("cocoon:/authenticate?" + loginParameters);
                
                return _currentUserProvider.getUser();
            }
            catch (IOException e)
            {
                getLogger().error("Impossible to test logins on population '" + userPopulation.getId() + "' using credential provider at position '" + credentialProviderIndex + "'");
            }
        }
        
        return null;
    }
}
