/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.plugins.mobileapp.action.AbstractPostAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

public class GetPopulationsAction
extends AbstractPostAction {
    protected PopulationContextHelper _populationContextHelper;
    protected UserPopulationDAO _userPopulationDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
    }

    @Override
    protected Map<String, Object> doAction(Request request, Map<String, Object> jsonParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String siteName = (String)this.getParameter("site", jsonParams, request);
        if (siteName != null) {
            List<CallSite> populationContexts = List.of("/sites/" + siteName, "/sites-fo/" + siteName);
            ArrayList<Map> userPopulationsList = new ArrayList<Map>();
            for (String string : populationContexts) {
                userPopulationsList.addAll(this._populationContextHelper.getUserPopulationsOnContexts(List.of(string), false, false).stream().map(arg_0 -> ((UserPopulationDAO)this._userPopulationDAO).getUserPopulation(arg_0)).filter(population -> this.isCorrectPopulation((UserPopulation)population)).map(userPopulation -> Map.of("key", userPopulation.getId(), "value", userPopulation.getLabel())).toList());
            }
            result.put("userPopulations", userPopulationsList);
        }
        result.put("code", 200);
        return result;
    }

    private boolean isCorrectPopulation(UserPopulation population) {
        return population.getCredentialProviders().stream().anyMatch(FormCredentialProvider.class::isInstance);
    }
}

