/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const siteManager = Ametys.serviceManager.lookup(org.ametys.web.repository.site.SiteManager.ROLE);

 const changeValue = function(queryId, session) 
 {
    if (queryId != null && queryId.length !== 0)
    {
        try
        {
            const queryContainer = Repository.resolver.resolveById(queryId, session);
            queryContainer.addAllowedProfilesForAnyConnectedUser(java.util.Set.of(org.ametys.core.right.RightManager.READER_PROFILE_ID));
        }
        catch (e)
        {
            // suppose its an unknown exception and ignore it
        }
    }
 }
   
const process = function(session) 
{
    const configQueryContainer = org.ametys.runtime.config.Config.getInstance().getValue("plugin.mobileapp.query.container");
    changeValue(configQueryContainer, session);

    for (const site of siteManager.getSites())
    {
       const siteQueryContainer = site.getValue("mobileapp-query-container");
       changeValue(siteQueryContainer, session);
    }

    if (session.hasPendingChanges())
    {
        session.save();
    }        
}

process(Repository.session);
process(Repository.liveSession);
