/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections4.CollectionUtils;

public class UserPreferencesHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = UserPreferencesHelper.class.getName();
    private static final String __USERPREF_KEY_LANG = "lang";
    private static final String __USERPREF_KEY_SITE = "site";
    private static final String __USERPREF_KEY_ENABLED = "enabled";
    private static final String __USERPREF_KEY_ALL_FEEDS = "allFeeds";
    private static final String __USERPREF_KEY_FEEDS = "feeds";
    private static final String __USERPREF_KEY_ALL_PROJECTS = "allProjects";
    private static final String __USERPREF_KEY_PROJECTS = "projects";
    private static final String __USERPREF_KEY_ALL_TYPES = "allTypes";
    private static final String __USERPREF_KEY_TYPES = "types";
    protected UserPreferencesManager _userPreferencesManager;
    protected CurrentUserProvider _currentUserProvider;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPreferencesManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public Map<String, Set<String>> getUserImpactedTokens(UserIdentity user, Set<String> feedIds, Site site) {
        HashMap<String, Set<String>> feedsAndTokens = new HashMap<String, Set<String>>();
        try {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            for (Map.Entry entry : unTypedUserPrefs.entrySet()) {
                String token = (String)entry.getKey();
                String value = (String)entry.getValue();
                Map prefs = this._jsonUtils.convertJsonToMap(value);
                List feeds = (List)prefs.get(__USERPREF_KEY_FEEDS);
                String siteName = (String)prefs.get(__USERPREF_KEY_SITE);
                boolean enabled = this._getValueOrDefault((Boolean)prefs.get(__USERPREF_KEY_ENABLED), true);
                boolean allFeeds = this._getValueOrDefault((Boolean)prefs.get(__USERPREF_KEY_ALL_FEEDS), feeds == null);
                if (!enabled) continue;
                boolean hasSiteQueries = site.hasValue("mobileapp-query-container");
                if (siteName != null && (!hasSiteQueries || !siteName.equals(site.getName()))) continue;
                Set<String> matchingFeeds = allFeeds || feeds == null ? feedIds : CollectionUtils.intersection((Iterable)feeds, feedIds);
                for (String feedId : matchingFeeds) {
                    Set tokens = feedsAndTokens.computeIfAbsent(feedId, __ -> new HashSet());
                    tokens.add(token);
                }
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to read a user notification token, for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
        return feedsAndTokens;
    }

    public Map<String, Set<String>> getUserImpactedTokens(UserIdentity user, Project project, String eventType) {
        HashMap<String, Set<String>> tokensForLanguage = new HashMap<String, Set<String>>();
        try {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            for (Map.Entry entry : unTypedUserPrefs.entrySet()) {
                boolean typeMatch;
                String token = (String)entry.getKey();
                String value = (String)entry.getValue();
                Map prefs = this._jsonUtils.convertJsonToMap(value);
                List projects = (List)prefs.get(__USERPREF_KEY_PROJECTS);
                List types = (List)prefs.get(__USERPREF_KEY_TYPES);
                boolean enabled = this._getValueOrDefault((Boolean)prefs.get(__USERPREF_KEY_ENABLED), true);
                boolean allProjects = this._getValueOrDefault((Boolean)prefs.get(__USERPREF_KEY_ALL_PROJECTS), projects == null);
                boolean allTypes = this._getValueOrDefault((Boolean)prefs.get(__USERPREF_KEY_ALL_TYPES), types == null);
                if (!enabled) continue;
                boolean projectMatch = allProjects || projects == null || projects.contains(project.getId());
                boolean bl = typeMatch = allTypes || types == null || types.contains(eventType);
                if (!projectMatch || !typeMatch) continue;
                String lang = (String)prefs.get(__USERPREF_KEY_LANG);
                Set tokens = tokensForLanguage.computeIfAbsent(lang, __ -> new HashSet());
                tokens.add(token);
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to read a user notification token, for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
        return tokensForLanguage;
    }

    private boolean _getValueOrDefault(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    public Set<String> getNotificationTokens() {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.getNotificationTokens(user);
    }

    public Set<String> getNotificationTokens(UserIdentity user) {
        try {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            return unTypedUserPrefs.keySet();
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to read a user notification token, for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
            return Collections.EMPTY_SET;
        }
    }

    public void removeNotificationToken(String pushToken) {
        UserIdentity user = this._currentUserProvider.getUser();
        this.removeNotificationToken(pushToken, user);
    }

    public void removeNotificationToken(String pushToken, UserIdentity user) {
        try {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            unTypedUserPrefs.remove(pushToken);
            this._userPreferencesManager.setUserPreferences(user, "/mobileapp", Collections.emptyMap(), unTypedUserPrefs);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to remove a user notification token, for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
    }

    public void removeAllNotificationTokens(UserIdentity user) {
        try {
            this._userPreferencesManager.removeAllUserPreferences(user, "/mobileapp", Collections.emptyMap());
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to remove all user notification tokens, for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
    }

    public void setNotificationSettings(String pushToken, boolean enabled, boolean allFeeds, List<String> feeds, boolean allProjects, List<String> projects, boolean allTypes, List<String> types, String lang) {
        UserIdentity user = this._currentUserProvider.getUser();
        this.setNotificationSettings(pushToken, enabled, allFeeds, feeds, allProjects, projects, allTypes, types, lang, user);
    }

    public synchronized void setNotificationSettings(String pushToken, boolean enabled, boolean allFeeds, List<String> feeds, boolean allProjects, List<String> projects, boolean allTypes, List<String> types, String lang, UserIdentity user) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(__USERPREF_KEY_LANG, lang);
        values.put(__USERPREF_KEY_ENABLED, enabled);
        values.put(__USERPREF_KEY_ALL_FEEDS, allFeeds);
        if (feeds != null) {
            values.put(__USERPREF_KEY_FEEDS, feeds);
        }
        values.put(__USERPREF_KEY_ALL_PROJECTS, allProjects);
        if (projects != null) {
            values.put(__USERPREF_KEY_PROJECTS, projects);
        }
        values.put(__USERPREF_KEY_ALL_TYPES, allTypes);
        if (types != null) {
            values.put(__USERPREF_KEY_TYPES, types);
        }
        values.put("epochDay", LocalDate.now().toEpochDay());
        String valuesAsString = this._jsonUtils.convertObjectToJson(values);
        try {
            HashMap<String, String> unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            if (unTypedUserPrefs == null) {
                unTypedUserPrefs = new HashMap<String, String>();
            }
            unTypedUserPrefs.put(pushToken, valuesAsString);
            this._userPreferencesManager.setUserPreferences(user, "/mobileapp", Collections.emptyMap(), unTypedUserPrefs);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to set user preferences for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
    }

    public Map<String, Object> getNotificationSettings(String pushToken, UserIdentity user) {
        try {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, "/mobileapp", Collections.emptyMap());
            if (unTypedUserPrefs != null && unTypedUserPrefs.containsKey(pushToken)) {
                String prefs = (String)unTypedUserPrefs.get(pushToken);
                return this._jsonUtils.convertJsonToMap(prefs);
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Impossible to retreive user preferences for user '" + UserIdentity.userIdentityToString((UserIdentity)user) + "'", (Throwable)e);
        }
        return null;
    }
}

