/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.observer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.mobileapp.FeedHelper;
import org.ametys.plugins.mobileapp.PushNotificationManager;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;
import org.ametys.plugins.mobileapp.action.GetEventTypesAction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ProjectActivityObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable {
    private static final String __PROJECT_ENABLED_CONF_ID = "plugin.mobileapp.project.enabled";
    private FeedHelper _feedHelper;
    private UserPreferencesHelper _userPreferencesHelper;
    private PushNotificationManager _pushNotificationManager;
    private ProjectManager _projectManager;
    private AmetysObjectResolver _resolver;
    private ProjectMemberManager _projectMemberHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._feedHelper = (FeedHelper)((Object)manager.lookup(FeedHelper.ROLE));
        this._userPreferencesHelper = (UserPreferencesHelper)((Object)manager.lookup(UserPreferencesHelper.ROLE));
        this._pushNotificationManager = (PushNotificationManager)((Object)manager.lookup(PushNotificationManager.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        if (PluginsManager.getInstance().isPluginActive("workspaces")) {
            this._projectManager = (ProjectManager)manager.lookup(ProjectManager.ROLE);
            this._projectMemberHelper = (ProjectMemberManager)manager.lookup(ProjectMemberManager.ROLE);
        }
    }

    public boolean supports(Event event) {
        return PluginsManager.getInstance().isPluginActive("workspaces") && (Boolean)Config.getInstance().getValue(__PROJECT_ENABLED_CONF_ID, false, (Object)false) != false && "activity.created".contains(event.getId());
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        ActivityType activityType;
        String activityId = (String)event.getArguments().get("activityId");
        Activity activity = (Activity)this._resolver.resolveById(activityId);
        if (GetEventTypesAction.EVENT_TYPES.containsKey(activity.getEventType()) && (activityType = activity.getActivityType()) instanceof AbstractWorkspacesActivityType) {
            Project project = this._projectManager.getProject((String)activity.getValue("projectName"));
            this.getLogger().info("Listing push notification to send for activity on project '{}'", (Object)project.getId());
            Map activity2json = activity.toJSONForClient();
            Map<String, Object> projectJson = this._feedHelper.projectToMap(project);
            Set members = this._projectMemberHelper.getProjectMembers(project, true);
            List<UserIdentity> users = members.stream().map(member -> member.getUser()).filter(Objects::nonNull).map(User::getIdentity).toList();
            HashMap<String, Map> langAndTokens = new HashMap<String, Map>();
            for (UserIdentity user : users) {
                Map<String, Set<String>> tokensForUser = this._userPreferencesHelper.getUserImpactedTokens(user, project, activity.getEventType());
                for (Map.Entry<String, Set<String>> tokensByLang : tokensForUser.entrySet()) {
                    Map tokens = langAndTokens.computeIfAbsent(tokensByLang.getKey(), __ -> new HashMap());
                    tokens.put(user, tokensByLang.getValue());
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Push tokens " + langAndTokens.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((Map)e.getValue()).size()).collect(Collectors.joining(", ")));
            }
            Map translatedNotificationContent = langAndTokens.keySet().stream().distinct().collect(Collectors.toMap(Function.identity(), lang -> this._feedHelper.getActivityInfos(activity2json, projectJson, (String)lang)));
            for (Map.Entry entry : langAndTokens.entrySet()) {
                String lang2 = (String)entry.getKey();
                Map tokens = (Map)entry.getValue();
                Map notificationData = translatedNotificationContent.get(lang2);
                try {
                    Map category = (Map)((Map)notificationData.get("project")).get("category");
                    String categoryLabel = ((I18nizableText)category.get("title")).getLabel();
                    category.put("title", categoryLabel);
                }
                catch (Exception category) {
                    // empty catch block
                }
                String title = project.getTitle();
                String message = (String)notificationData.get("short-description");
                this._pushNotificationManager.pushNotifications(title, message, tokens, null);
            }
        }
    }
}

