/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.mobileapp.PushNotificationManager.TokenInfo;

/**
 * Schedulable for checking push notifications receipts, a few minutes after sending.
 */
public class PushReceiptsSchedulable extends AbstractStaticSchedulable
{
    private PushNotificationManager _pushNotificationManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _pushNotificationManager = (PushNotificationManager) manager.lookup(PushNotificationManager.ROLE);
    }
    
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        // Get tickets to check
        JobDataMap dataMap = context.getMergedJobDataMap();
        
        @SuppressWarnings("unchecked")
        Map<String, TokenInfo> tickets = (Map<String, TokenInfo>) dataMap.get("parameterValues#tickets");
        
        _pushNotificationManager.checkTickets(tickets);
    }
}
