/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ExplorerFile;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.ui.model.SearchUIModel;
import org.ametys.cms.search.ui.model.SearchUIModelExtensionPoint;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.mobileapp.SearchModelWrapper;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.QueryHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class QueriesHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = QueriesHelper.class.getName();
    public static final String QUERY_CONTAINER_CONF_ID = "plugin.mobileapp.query.container";
    public static final String QUERY_CONTAINER_SITE_CONF_ID = "mobileapp-query-container";
    public static final String QUERY_LIMIT_CONF_ID = "plugin.mobileapp.query.limit";
    protected ServiceManager _manager;
    private AmetysObjectResolver _resolver;
    private QueryHelper _queriesHelper;
    private SearchUIModelExtensionPoint _searchUiEP;
    private ContentTypesHelper _contentTypesHelper;
    private ContentSearcherFactory _contentSearcherFactory;
    private SiteManager _siteManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    protected AmetysObjectResolver getResolver() {
        if (this._resolver == null) {
            try {
                this._resolver = (AmetysObjectResolver)this._manager.lookup(AmetysObjectResolver.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving AmetysObjectResolver", (Throwable)e);
            }
        }
        return this._resolver;
    }

    protected QueryHelper getQueriesManager() {
        if (this._queriesHelper == null) {
            try {
                this._queriesHelper = (QueryHelper)this._manager.lookup(QueryHelper.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving QueriesManager", (Throwable)e);
            }
        }
        return this._queriesHelper;
    }

    protected SearchUIModelExtensionPoint getSearchUIModelExtensionPoint() {
        if (this._searchUiEP == null) {
            try {
                this._searchUiEP = (SearchUIModelExtensionPoint)this._manager.lookup(SearchUIModelExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving SearchUIModelExtensionPoint", (Throwable)e);
            }
        }
        return this._searchUiEP;
    }

    protected ContentTypesHelper getContentTypesHelper() {
        if (this._contentTypesHelper == null) {
            try {
                this._contentTypesHelper = (ContentTypesHelper)this._manager.lookup(ContentTypesHelper.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving ContentTypesHelper", (Throwable)e);
            }
        }
        return this._contentTypesHelper;
    }

    protected SiteManager getSiteManager() {
        if (this._siteManager == null) {
            try {
                this._siteManager = (SiteManager)this._manager.lookup(SiteManager.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving SiteManager", (Throwable)e);
            }
        }
        return this._siteManager;
    }

    protected ContentSearcherFactory getContentSearcherFactory() {
        if (this._contentSearcherFactory == null) {
            try {
                this._contentSearcherFactory = (ContentSearcherFactory)this._manager.lookup(ContentSearcherFactory.ROLE);
            }
            catch (ServiceException e) {
                this.getLogger().error("Error while retrieving SiteManager", (Throwable)e);
            }
        }
        return this._contentSearcherFactory;
    }

    public List<Query> getQueries(Site site) {
        String queryContainerId;
        String string = queryContainerId = site != null ? (String)site.getValue(QUERY_CONTAINER_SITE_CONF_ID) : null;
        if (StringUtils.isBlank((CharSequence)queryContainerId)) {
            queryContainerId = (String)Config.getInstance().getValue(QUERY_CONTAINER_CONF_ID);
        }
        AmetysObject ametysObject = this.getResolver().resolveById(queryContainerId);
        return this.getQueries(ametysObject);
    }

    public List<Query> getQueries(AmetysObject ametysObject) {
        this.getLogger().info("Fetch queries under query '{}'", (Object)ametysObject.getId());
        if (ametysObject instanceof QueryContainer) {
            QueryContainer queryContainer = (QueryContainer)ametysObject;
            return queryContainer.getChildren().stream().map(q -> this.getQueries((AmetysObject)q)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (ametysObject instanceof Query) {
            this.getLogger().info("Query '{}' is not a container", (Object)ametysObject.getId());
            return ImmutableList.of((Object)((Query)ametysObject));
        }
        this.getLogger().info("Query '{}' is empty", (Object)ametysObject.getId());
        return Collections.EMPTY_LIST;
    }

    public AmetysObjectIterable<Content> executeQuery(Query query, List<ContentSearcherFactory.ContentSearchSort> sort, boolean checkRights) {
        this.getLogger().info("Execute query '{}', testing rights : '{}'", (Object)query.getId(), (Object)checkRights);
        try {
            Long limit = (Long)Config.getInstance().getValue(QUERY_LIMIT_CONF_ID);
            Map exportParams = this.getQueriesManager().getExportParams(query);
            String model = this.getQueriesManager().getModelForQuery(exportParams);
            if ("solr".equals(query.getType())) {
                String queryStr = this.getQueriesManager().getQueryStringForQuery(exportParams);
                Set contentTypeIds = this.getQueriesManager().getContentTypesForQuery(exportParams).stream().collect(Collectors.toSet());
                AmetysObjectIterable results = this.getContentSearcherFactory().create(contentTypeIds).setCheckRights(checkRights).withSort(sort).withLimits(0, limit.intValue()).search(queryStr);
                this.getLogger().info("Query '{}' returned {} results", (Object)query.getId(), (Object)results.getSize());
                return results;
            }
            if (Query.Type.SIMPLE.toString().equals(query.getType()) || Query.Type.ADVANCED.toString().equals(query.getType())) {
                Map values = this.getQueriesManager().getValuesForQuery(exportParams);
                Map contextualParameters = this.getQueriesManager().getContextualParametersForQuery(exportParams);
                String searchMode = this.getQueriesManager().getSearchModeForQuery(exportParams);
                SearchUIModel uiModel = (SearchUIModel)this.getSearchUIModelExtensionPoint().getExtension(model);
                SearchModelWrapper wrappedUiModel = new SearchModelWrapper(uiModel, this._manager, this.getLogger());
                ContentSearcherFactory.SearchModelContentSearcher searcher = this.getContentSearcherFactory().create((SearchModel)wrappedUiModel);
                AmetysObjectIterable results = searcher.setCheckRights(checkRights).withLimits(0, limit.intValue()).withSort(sort).withSearchMode(searchMode).search(values, contextualParameters);
                this.getLogger().info("Query '{}' returned {} results", (Object)query.getId(), (Object)results.getSize());
                return results;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error during the execution of the query '" + query.getTitle() + "' (" + query.getId() + ")", (Throwable)e);
        }
        return null;
    }

    public Set<Query> getQueriesForResult(AmetysObject content, Site site) {
        return this.getQueriesForResult(content.getId(), site);
    }

    public Set<Query> getQueriesForResult(String contentId, Site site) {
        Map<String, Set<Query>> queriesForResult = this.getQueriesForResult(List.of(contentId), site);
        if (queriesForResult.containsKey(contentId)) {
            return queriesForResult.get(contentId);
        }
        return Collections.EMPTY_SET;
    }

    public Map<String, Set<Query>> getQueriesForResult(List<String> contents, Site site) {
        HashMap<String, Set<Query>> result = new HashMap<String, Set<Query>>();
        List<Query> queries = this.getQueries(site);
        this.getLogger().info("Searching for queries returning contents : {}", contents);
        for (Query query : queries) {
            this.getLogger().info("Searching with query : {}", (Object)query.getId());
            try {
                List<ContentSearcherFactory.ContentSearchSort> sort = this.getSortProperty(query, queries.size() > 1);
                AmetysObjectIterable<Content> searchResults = this.executeQuery(query, sort, false);
                if (searchResults == null) continue;
                List resultIds = searchResults.stream().map(c -> c.getId()).collect(Collectors.toList());
                for (String resultId : resultIds) {
                    if (!contents.contains(resultId)) continue;
                    this.getLogger().info("Query : {} contains content : {}", (Object)query.getId(), (Object)resultId);
                    if (!result.containsKey(resultId)) {
                        result.put(resultId, new HashSet());
                    }
                    ((Set)result.get(resultId)).add(query);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error during the execution of the query '" + query.getTitle() + "' (" + query.getId() + ")", (Throwable)e);
            }
        }
        if (result.isEmpty()) {
            this.getLogger().info("No query found for contents '{}'", contents);
        }
        return result;
    }

    public List<ContentSearcherFactory.ContentSearchSort> getSortProperty(Query query, boolean moreThanOne) {
        Map exportParams = this.getQueriesManager().getExportParams(query);
        List baseSort = this.getQueriesManager().getSortForQuery(exportParams);
        if (!moreThanOne && baseSort != null && !baseSort.isEmpty()) {
            return baseSort;
        }
        if (baseSort != null && !baseSort.isEmpty()) {
            ContentSearcherFactory.ContentSearchSort firstSort = (ContentSearcherFactory.ContentSearchSort)baseSort.get(0);
            Set<String> specificFields = Set.of("creationDate", "lastValidation", "lastModified");
            if (specificFields.contains(firstSort.sortField())) {
                return List.of(new ContentSearcherFactory.ContentSearchSort(firstSort.sortField(), SortOrder.ASC));
            }
            List contentTypesForQuery = this.getQueriesManager().getContentTypesForQuery(exportParams);
            if (contentTypesForQuery != null) {
                String[] contentTypeIdsAsArray = contentTypesForQuery.toArray(new String[contentTypesForQuery.size()]);
                try {
                    ModelItem modelItem = this.getContentTypesHelper().getModelItem(firstSort.sortField(), contentTypeIdsAsArray, new String[0]);
                    String sortFileTypeId = modelItem.getType().getId();
                    if ("date".equals(sortFileTypeId) || "datetime".equals(sortFileTypeId)) {
                        return List.of(new ContentSearcherFactory.ContentSearchSort(firstSort.sortField(), SortOrder.ASC));
                    }
                }
                catch (UndefinedItemPathException e) {
                    this.getLogger().warn("Error while fetching the model of the field '" + firstSort.sortField() + "' for content types [" + String.join((CharSequence)", ", contentTypesForQuery) + "]", (Throwable)e);
                }
            }
        }
        ContentSearcherFactory.ContentSearchSort sort = new ContentSearcherFactory.ContentSearchSort("lastValidation", SortOrder.ASC);
        return List.of(sort);
    }

    public Map<String, String> getDataForContent(Content content) {
        WebContent webContent;
        Iterator pages;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("content_id", content.getId());
        if (content.hasValue("illustration/image")) {
            String image = null;
            Object value = content.getValue("illustration/image");
            if (value instanceof ExplorerFile) {
                ExplorerFile file = (ExplorerFile)value;
                image = ResolveURIComponent.resolveCroppedImage((String)"explorer", (String)file.getResourceId(), (int)1024, (int)1024, (boolean)false, (boolean)true);
            } else {
                String imgUri = "illustration/image?contentId=" + content.getId();
                image = ResolveURIComponent.resolveCroppedImage((String)"attribute", (String)imgUri, (int)1024, (int)1024, (boolean)false, (boolean)true);
            }
            if (image != null) {
                result.put("image", image);
            }
        }
        result.put("title", content.getTitle());
        if (content instanceof WebContent && (pages = (webContent = (WebContent)content).getReferencingPages().iterator()).hasNext()) {
            Page page = (Page)pages.next();
            String siteName = webContent.getSiteName();
            String url = this.getSiteManager().getSite(siteName).getUrl() + "/" + page.getSitemap().getName() + "/" + page.getPathInSitemap() + ".html";
            result.put("content_url", url);
        }
        return result;
    }

    public Instant toInstant(Object o1, Object o2) {
        if (o1 instanceof ZonedDateTime) {
            return ((ZonedDateTime)o1).toInstant();
        }
        if (o1 instanceof LocalDate) {
            if (o2 instanceof ZonedDateTime) {
                LocalDate ld1 = (LocalDate)o1;
                ZonedDateTime zdt2 = (ZonedDateTime)o2;
                return ld1.atStartOfDay(zdt2.getZone()).toInstant();
            }
            return ((LocalDate)o1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
        if (o1 instanceof Date) {
            return ((Date)o1).toInstant();
        }
        return null;
    }

    public String getContentFormattedDate(Content content, String field) {
        String isoDate = null;
        if (StringUtils.isNotBlank((CharSequence)field) && content.hasValue(field)) {
            Object value = content.getValue(field, true, null);
            if (value instanceof Date) {
                isoDate = DateUtils.dateToString((Date)((Date)value));
            } else {
                Instant instant = this.toInstant(value, null);
                if (instant != null) {
                    Date date = new Date(instant.toEpochMilli());
                    isoDate = DateUtils.dateToString((Date)date);
                }
            }
        } else if ("lastModified".equals(field)) {
            isoDate = DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified());
        }
        if (StringUtils.isBlank(isoDate)) {
            isoDate = DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastValidationDate());
        }
        return isoDate;
    }
}

