/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

import org.ametys.core.right.RightManager;
import org.ametys.plugins.mobileapp.PostConstants;
import org.ametys.plugins.mobileapp.QueriesHelper;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;

/**
 * Returns the list of feeds for a user
 */
public class GetFeedsAction extends AbstractLoggedAction
{
    /** The Ametys object resolver */
    protected QueriesHelper _queryHelper;

    /** Authentication Token Manager */
    protected SiteManager _siteManager;
    
    private RightManager _rightManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _queryHelper = (QueriesHelper) smanager.lookup(QueriesHelper.ROLE);
        _siteManager = (SiteManager) smanager.lookup(SiteManager.ROLE);
        _rightManager = (RightManager) smanager.lookup(RightManager.ROLE);
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams)
    {
        Map<String, Object> result = new HashMap<>();

        String siteName = (String) getParameter(PostConstants.SITE_NAME, jsonParams, request);

        Site site = _siteManager.getSite(siteName);

        List<Query> queries = _queryHelper.getQueries(site);

        List<Map<String, String>> feedList = new ArrayList<>();

        for (Query query : queries)
        {
            if (_rightManager.hasReadAccess(_currentUserProvider.getUser(), query))
            {
                Map<String, String> queryMap = new HashMap<>();
                queryMap.put("name", query.getTitle());
                queryMap.put("feed_id", query.getId());
                feedList.add(queryMap);
            }
        }

        result.put("feed_list", feedList);

        return result;
    }

}
