/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.plugins.mobileapp.FeedHelper;
import org.ametys.plugins.mobileapp.PostConstants;
import org.ametys.runtime.plugin.PluginsManager;

/**
 * Returns the list of feeds for a user
 */
public class GetProjectsFeedAction extends AbstractLoggedAction
{
    /** Feed Helper */
    private FeedHelper _feedHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        if (PluginsManager.getInstance().isPluginActive("workspaces"))
        {
            _feedHelper = (FeedHelper) smanager.lookup(FeedHelper.ROLE);
        }
    }
    
    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams)
    {
        if (_feedHelper != null)
        {
            Object result = request.getAttribute(ActionResultGenerator.MAP_REQUEST_ATTR);
            if (result instanceof Map<?, ?>)
            {
                @SuppressWarnings("unchecked")
                Map<String, Object> resultMap = (Map<String, Object>) result;
                
                String lang = (String) getParameter(PostConstants.LANG, jsonParams, request);
                
                Map<String, Map<String, Object>> projects = _feedHelper.getProjects();
                
                @SuppressWarnings("unchecked")
                List<Map<String, Object>> resultList = ((List<Map<String, Object>>) resultMap.get("events")).stream()
                                                                                                            .sorted((event1, event2) -> ((String) event2.get("date")).compareTo((String) event1.get("date")))
                                                                                                            .toList();
                
                List<Map<String, Object>> jsonResult = new ArrayList<>();
                for (Object object : resultList)
                {
                    Map<String, Object> addActivityInfos;
                    if (object instanceof Map)
                    {
                        @SuppressWarnings("unchecked")
                        Map<String, Object> activity = (Map<String, Object>) object;
                        Map<String, Object> project = projects.get(activity.get("projectName"));
                        addActivityInfos = _feedHelper.getActivityInfos(activity, project, lang);
                    }
                    else
                    {
                        addActivityInfos = new HashMap<>();
                    }
                    if (addActivityInfos != null)
                    {
                        jsonResult.add(addActivityInfos);
                    }
                }
                
                Map<String, Object> output = new HashMap<>();
                output.put("items", jsonResult);
                return output;
            }
            
            // Nom de l'action (membre ajouté, nouvel évènement, etc…)
            // Short description
        }
        return EMPTY_MAP;
    }
}
