/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.observer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.RichTextHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.right.AllowedUsers;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.mobileapp.PushNotificationManager;
import org.ametys.plugins.mobileapp.QueriesHelper;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class ContentValidatedObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable,
Contextualizable {
    private static final String __DESCRIPTION_MAX_SIZE_CONF_ID = "plugin.mobileapp.push.description.richtext.max";
    private Context _context;
    private QueriesHelper _queryHelper;
    private UserPreferencesHelper _userPreferencesHelper;
    private PushNotificationManager _pushNotificationManager;
    private UserManager _userManager;
    private UserPopulationDAO _userPopulationDAO;
    private RightManager _rightManager;
    private RichTextHelper _richTextHelper;
    private AmetysObjectResolver _resolver;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._queryHelper = (QueriesHelper)((Object)manager.lookup(QueriesHelper.ROLE));
        this._userPreferencesHelper = (UserPreferencesHelper)((Object)manager.lookup(UserPreferencesHelper.ROLE));
        this._pushNotificationManager = (PushNotificationManager)((Object)manager.lookup(PushNotificationManager.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._richTextHelper = (RichTextHelper)manager.lookup(RichTextHelper.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.validated") || event.getId().equals("content.tagged");
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Thread.sleep(5000L);
        String contentId = (String)event.getArguments().get("content.id");
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            Set users;
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
            if (!this._resolver.hasAmetysObjectForId(contentId)) {
                this.getLogger().debug("Content with id {} does not exists in workspace live, no push notification will be sent.", (Object)contentId);
                return;
            }
            Content content = (Content)this._resolver.resolveById(contentId);
            if (!(content instanceof WebContent)) {
                this.getLogger().debug("We currently do not support push notifications for off-site content {}", (Object)content.getId());
                return;
            }
            WebContent webContent = (WebContent)content;
            Site site = webContent.getSite();
            Set<Query> queries = this._queryHelper.getQueriesForResult(content.getId(), site);
            this.getLogger().info("{} queries found for content {}", (Object)queries.size(), (Object)content.getId());
            if (queries.isEmpty()) {
                return;
            }
            AllowedUsers readAccessAllowedUsers = this._rightManager.getReadAccessAllowedUsers((Object)content);
            if (readAccessAllowedUsers.isAnonymousAllowed() || readAccessAllowedUsers.isAnyConnectedUserAllowed()) {
                List userPopulationsIds = this._userPopulationDAO.getUserPopulationsIds();
                Collection allUsers = this._userManager.getUsersByPopulationIds(userPopulationsIds);
                users = allUsers.stream().map(User::getIdentity).collect(Collectors.toSet());
            } else {
                users = readAccessAllowedUsers.resolveAllowedUsers(true);
            }
            Map queryMap = queries.stream().collect(Collectors.toMap(SimpleAmetysObject::getId, Function.identity()));
            Set<String> feedIds = queryMap.keySet();
            HashMap<String, Map> notificationsNeeded = new HashMap<String, Map>();
            for (UserIdentity user : users) {
                Map<String, Set<String>> tokensForUser = this._userPreferencesHelper.getUserImpactedTokens(user, feedIds, site);
                for (Map.Entry<String, Set<String>> tokensByFeed : tokensForUser.entrySet()) {
                    Query query = (Query)queryMap.get(tokensByFeed.getKey());
                    if (!this._rightManager.hasReadAccess(user, (Object)query)) continue;
                    Map tokens = notificationsNeeded.computeIfAbsent(tokensByFeed.getKey(), __ -> new HashMap());
                    tokens.put(user, tokensByFeed.getValue());
                }
            }
            Map<String, String> data = this._queryHelper.getDataForContent(content);
            Map<String, String> sorts = queries.stream().collect(Collectors.toMap(SimpleAmetysObject::getId, q -> this._queryHelper.getSortProperty((Query)q, true).get(0).sortField()));
            for (Map.Entry entry : notificationsNeeded.entrySet()) {
                HashMap<String, Object> notificationData = new HashMap<String, Object>();
                notificationData.putAll(data);
                String feedId = (String)entry.getKey();
                notificationData.put("feed_id", feedId);
                if (queryMap.containsKey(feedId)) {
                    notificationData.put("category_name", ((Query)queryMap.get(feedId)).getTitle());
                }
                String sortField = null;
                if (sorts.containsKey(feedId)) {
                    sortField = sorts.get(feedId);
                }
                String isoDate = this._queryHelper.getContentFormattedDate(content, sortField);
                notificationData.put("date", isoDate);
                String description = this._getContentDescription(content);
                this._pushNotificationManager.pushNotifications(content.getTitle(), description, (Map)entry.getValue(), notificationData);
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    protected String _getContentDescription(Content content) {
        Long maxSize = (Long)Config.getInstance().getValue(__DESCRIPTION_MAX_SIZE_CONF_ID);
        String result = "";
        if (content.hasValue("abstract") && "string".equals(content.getDefinition("abstract").getType().getId())) {
            result = (String)content.getValue("abstract", false, (Object)"");
        } else if (content.hasValue("content") && "rich-text".equals(content.getDefinition("content").getType().getId())) {
            RichText richText = (RichText)content.getValue("content");
            result = this._richTextHelper.richTextToString(richText, maxSize.intValue());
        }
        return result;
    }
}

