<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              exclude-result-prefixes="docbook resolver"
                              xmlns:datetime="http://ametys.org/datetime/4.2"
                              extension-element-prefixes="datetime">
    
    <xsl:import href="view://stylesheets/content/common.xsl"/>
    <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">news</xsl:variable>
	

    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content">
            <xsl:with-param name="title" select="metadata/title"/>
        </xsl:call-template>
    </xsl:template> 

    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title">
        <xsl:call-template name="common-content-body-title-content">
            <xsl:with-param name="title" select="metadata/title"/>
            <xsl:with-param name="subtitle" select="metadata/document-subtitle"/>
        </xsl:call-template>
    </xsl:template>         
	
	<xsl:template name="dates">
		<xsl:param name="startDate"/>
		<xsl:param name="endDate"/>
		
		<p class="content-date">
			<xsl:choose>
				<xsl:when test="$startDate and not($endDate)">
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
						<xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$endDate and not($startDate)">
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate and datetime:sameDate($startDate, $endDate)">
                    <!-- case when the two datetimes represent the same date -->
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate">
					<i18n:text i18n:key="CONTENT_NEWS_DATE_FROM" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
					<i18n:text i18n:key="CONTENT_NEWS_DATE_TO" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtend'"/>
					</xsl:call-template>
				</xsl:when>
				
			</xsl:choose>
		</p>
	</xsl:template>
    
    <xsl:template name="news-date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        
        <xsl:choose>
            <xsl:when test="$role = 'dtstart' or $role = 'dtend'">
                <abbr class="{$role}">
                    <span class="value-title" title="{$date}"></span>
                    <xsl:call-template name="common-utils-date-pattern">
                        <xsl:with-param name="date" select="$date"/>
                    </xsl:call-template>
                </abbr>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="common-utils-date-pattern">
                    <xsl:with-param name="date" select="$date"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
