<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:uri="org.ametys.core.util.URIUtils"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="resolver uri cms">
    
    <xsl:import href="plugin:cms://stylesheets/helper/common.xsl"/>
    <xsl:import href="view://stylesheets/io/docbook2fo.xsl" />
    
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="page"
                    page-width="210mm" page-height="297mm" margin-left="0cm"
                    margin-right="0cm" margin-top="0cm" margin-bottom="0cm">
					<fo:region-body margin-top="3cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
					<fo:region-before extent="0cm">
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
					<fo:region-after extent="0cm">
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <xsl:apply-templates />
        </fo:root>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
    </xsl:template>
    
    <xsl:template match="content">
        <fo:page-sequence master-reference="page">
            
            <xsl:call-template name="xsl-region-before"/>
            
            <fo:flow flow-name="xsl-region-body">
                <fo:block margin-left="1cm" margin-right="1cm">
                    <xsl:call-template name="main-body-block"/>
                    
                    <fo:block>
                        <xsl:call-template name="title-style">
                            <xsl:with-param name="level" select="2"/>
                        </xsl:call-template>
                        
                        <xsl:value-of select="metadata/title" />
                        
                        <xsl:if test="metadata/document-subtitle != ''">
                            <fo:block>
                                <xsl:call-template name="subtitle-style">
                                    <xsl:with-param name="level" select="2"/>
                                </xsl:call-template>
                                
                                <xsl:value-of select="metadata/document-subtitle" />
                            </fo:block>
                        </xsl:if>
					</fo:block>
                    
                    <xsl:if test="metadata/start-date or metadata/end-date">
                        <xsl:call-template name="dates">
                            <xsl:with-param name="startDate" select="metadata/start-date"/>
                            <xsl:with-param name="endDate" select="metadata/end-date"/>
                        </xsl:call-template>
                    </xsl:if>
                    
                    <fo:block>
                        
                        <xsl:if test="metadata/illustration/image">
                            <xsl:call-template name="content-illustration"/>
                        </xsl:if>
                        
                        <xsl:if test="cms:isNotRichTextEmpty(metadata/content)">
                            <xsl:apply-templates select="metadata/content/docbook:article">
                                <xsl:with-param name="level" select="3"/>
                            </xsl:apply-templates>
                        </xsl:if>
                    </fo:block>
                </fo:block>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
    
    <xsl:template name="content-illustration">
		<fo:external-graphic src="{uri:decode(resolver:resolveBoundedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 150, 150, false(), false(), true()))}">
            <xsl:call-template name="image-style">
                <xsl:with-param name="class" select="'illustration'"/>
            </xsl:call-template>
        </fo:external-graphic>
    </xsl:template>
    
    <xsl:template name="dates">
        <xsl:param name="startDate"/>
        <xsl:param name="endDate"/>
        
        <fo:block>
            <xsl:call-template name="content-date-style"/>
            
            <xsl:choose>
                <xsl:when test="$startDate and not($endDate)">
                    <i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
                    <xsl:call-template name="date-pattern">
                        <xsl:with-param name="date" select="$startDate"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$endDate and not($startDate)">
                    <i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
                    <xsl:call-template name="date-pattern">
                        <xsl:with-param name="date" select="$endDate"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$startDate and $endDate">
                    <i18n:text i18n:key="CONTENT_NEWS_DATE_FROM" i18n:catalogue="plugin.news"/>
                    <xsl:call-template name="date-pattern">
                        <xsl:with-param name="date" select="$startDate"/>
                    </xsl:call-template>
                    <i18n:text i18n:key="CONTENT_NEWS_DATE_TO" i18n:catalogue="plugin.news"/>
                    <xsl:call-template name="date-pattern">
                        <xsl:with-param name="date" select="$endDate"/>
                    </xsl:call-template>
                </xsl:when>
                
            </xsl:choose>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="date-pattern">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template>
        
	<!-- +
	     | Default style
	     + -->
    <xsl:template name="region-body-definition"/>
    
    <xsl:template name="region-before-definition"/>
    
    <xsl:template name="region-after-definition"/>
    
    <xsl:template name="main-body-block"/>
    
    <xsl:template name="content-body-style"/>
    
    <xsl:template name="para-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="subscript">
    </xsl:template>
    
    <xsl:template name="supscript">
    </xsl:template>
    
    <xsl:template name="title-style">
        <xsl:param name="level"/>
    </xsl:template>
    
    <xsl:template name="image-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="image-caption">
    </xsl:template>
    
    <xsl:template name="link-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="link-href-style">
    </xsl:template>
    
    <xsl:template name="table-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="table-caption"/>
    
    <xsl:template name="tr-style">
        <xsl:param name="class"/>
    </xsl:template>
         
    <xsl:template name="th-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="td-style">
        <xsl:param name="class"/>
    </xsl:template>
    
    <xsl:template name="ol-style">
        <xsl:param name="mark"/>
    </xsl:template>
    
    <xsl:template name="ul-style">
        <xsl:param name="mark"/>
    </xsl:template>
    
    <xsl:template name="content-date-style"/>
    
</xsl:stylesheet>
