/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.plugins.newsletter.category.CategoryFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.web.repository.site.Site;

public class JCRCategory
extends DefaultTraversableAmetysObject<CategoryFactory> {
    private static final String __METADATA_TITLE = "ametys-internal:title";
    private static final String __METADATA_DESC = "ametys-internal:description";
    private static final String __METADATA_TEMPLATE = "ametys-internal:template";
    private static final String __AUTOMATIC_IDS = "ametys-internal:automatic-ids";

    public JCRCategory(Node node, String parentPath, CategoryFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__METADATA_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__METADATA_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public String getDescription() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__METADATA_DESC).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get description property", (Throwable)e);
        }
    }

    public void setDescription(String description) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__METADATA_DESC, description);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set description property", (Throwable)e);
        }
    }

    public String getTemplate() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__METADATA_TEMPLATE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get template property", (Throwable)e);
        }
    }

    public void setTemplate(String templateName) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__METADATA_TEMPLATE, templateName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set template property", (Throwable)e);
        }
    }

    public Collection<String> getAutomaticIds() throws AmetysRepositoryException {
        try {
            Value[] values;
            ArrayList<String> automaticIds = new ArrayList<String>();
            for (Value value : values = this.getNode().getProperty(__AUTOMATIC_IDS).getValues()) {
                automaticIds.add(value.getString());
            }
            return automaticIds;
        }
        catch (PathNotFoundException e) {
            return Collections.emptyList();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get template property", (Throwable)e);
        }
    }

    public void setAutomaticIds(Collection<String> autoIds) throws AmetysRepositoryException {
        try {
            String[] autoIdsArray = autoIds.toArray(new String[autoIds.size()]);
            this.getNode().setProperty(__AUTOMATIC_IDS, autoIdsArray);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set template property", (Throwable)e);
        }
    }

    public String getSiteName() {
        for (AmetysObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Site)) continue;
            return ((Site)parent).getName();
        }
        return null;
    }

    public String getLang() {
        for (AmetysObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getParent().getName().equals("ametys:categories")) continue;
            return parent.getName();
        }
        return null;
    }
}

