/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.JCRCategory;
import org.ametys.plugins.newsletter.category.NewsletterTemplate;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.slf4j.LoggerFactory;

public class TemplatesMenu
extends SimpleMenu
implements Contextualizable {
    protected static final String _RESOURCES_PLUGIN = "newsletter";
    private static final String GALLERY_ITEM_MANAGER = TemplatesMenu.class.getName() + "$GalleryItemManager";
    private static final String GALLERY_ITEMS = TemplatesMenu.class.getName() + "$GalleryItems";
    protected SkinsManager _skinsManager;
    protected SiteManager _siteManager;
    protected SourceResolver _sourceResolver;
    protected ServiceManager _manager;
    protected I18nUtils _i18nUtils;
    protected AmetysObjectResolver _resolver;
    private Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._manager = smanager;
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleCategory"})
    public Map<String, Object> getStatus(List<String> categoryIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("categories", new ArrayList());
        for (String categoryId : categoryIds) {
            JCRCategory category = (JCRCategory)this._resolver.resolveById(categoryId);
            Map<String, Object> categoryParams = this.getCategoryDefaultParameters(category);
            categoryParams.put("template", category.getTemplate());
            List categories = (List)result.get("categories");
            categories.add(categoryParams);
        }
        return result;
    }

    protected Map<String, Object> getCategoryDefaultParameters(JCRCategory category) {
        HashMap<String, Object> categoryParams = new HashMap<String, Object>();
        categoryParams.put("id", category.getId());
        categoryParams.put("title", category.getTitle());
        return categoryParams;
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        String siteName = (String)contextParameters.get("siteName");
        String skinId = this._siteManager.getSite(siteName).getSkinId();
        Skin skin = this._skinsManager.getSkin(skinId);
        if (skin.getTemplates().size() == 0) {
            return new ArrayList<ClientSideElement.Script>();
        }
        try {
            this._lazyInitializeTemplateGallery(contextParameters);
            List list = super.getScripts(ignoreRights, contextParameters);
            return list;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        finally {
            this._getGalleryItemManager().dispose();
        }
    }

    public List<String> getTemplate(List<String> categoryIds) {
        ArrayList<String> templates = new ArrayList<String>();
        for (String id : categoryIds) {
            Category category = (Category)this._resolver.resolveById(id);
            if (templates.contains(category.getTemplate())) continue;
            templates.add(category.getTemplate());
        }
        return templates;
    }

    protected ThreadSafeComponentManager<ClientSideElement> _getGalleryItemManager() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (ThreadSafeComponentManager)request.getAttribute(GALLERY_ITEM_MANAGER);
    }

    protected List<SimpleMenu.GalleryItem> _getGalleryItems() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (List)request.getAttribute(GALLERY_ITEMS);
    }

    private void _lazyInitializeTemplateGallery(Map<String, Object> contextualParameters) throws ConfigurationException {
        String siteName = (String)contextualParameters.get("siteName");
        Request request = ContextHelper.getRequest((Context)this._context);
        ThreadSafeComponentManager oldGalleryItemManagerInSameRequest = (ThreadSafeComponentManager)request.getAttribute(GALLERY_ITEM_MANAGER);
        if (oldGalleryItemManagerInSameRequest != null) {
            oldGalleryItemManagerInSameRequest.dispose();
        }
        ThreadSafeComponentManager galleryItemManager = new ThreadSafeComponentManager();
        galleryItemManager.setLogger(LoggerFactory.getLogger((String)"cms.plugin.threadsafecomponent"));
        galleryItemManager.service(this._smanager);
        request.setAttribute(GALLERY_ITEM_MANAGER, (Object)galleryItemManager);
        ArrayList<SimpleMenu.GalleryItem> galleryItems = new ArrayList<SimpleMenu.GalleryItem>();
        request.setAttribute(GALLERY_ITEMS, galleryItems);
        Site site = this._siteManager.getSite(siteName);
        String skinId = site.getSkinId();
        HashSet<String> templatesId = new HashSet<String>();
        try {
            TraversableSource dir = (TraversableSource)this._sourceResolver.resolveURI("skin:" + skinId + "://newsletter");
            if (dir.exists()) {
                for (TraversableSource child : dir.getChildren()) {
                    if (!this._templateExists(skinId, child.getName())) continue;
                    templatesId.add(child.getName());
                }
            }
        }
        catch (SourceNotFoundException sourceNotFoundException) {
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot find template for the skin " + skinId, (Throwable)e);
        }
        if (!templatesId.isEmpty()) {
            SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
            SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_CATEGORY_TEMPLATESMENU_GROUP_LABEL"));
            galleryItem.addGroup(galleryGroup);
            for (String templateId : templatesId) {
                String id = this.getId() + "." + templateId;
                try {
                    NewsletterTemplate template = new NewsletterTemplate(skinId, templateId);
                    LifecycleHelper.setupComponent((Object)((Object)template), (Logger)new SLF4JLoggerAdapter(this.getLogger()), null, (ServiceManager)this._manager, null, (boolean)true);
                    template.refreshValues();
                    Configuration conf = this._getTemplateItemConfiguration(id, template);
                    galleryItemManager.addComponent(this._pluginName, null, id, StaticClientSideElement.class, conf);
                    galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, id, true));
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to configure local client side element of id " + id, (Throwable)e);
                }
            }
            galleryItems.add(galleryItem);
        }
        if (galleryItems.size() > 0) {
            try {
                galleryItemManager.initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
            }
        }
    }

    private boolean _templateExists(String skinId, String id) throws IOException {
        TraversableSource skinsDir = (TraversableSource)this._sourceResolver.resolveURI("skin:" + skinId + "://newsletter/" + id + "/stylesheets/template.xsl");
        return skinsDir.exists();
    }

    protected Configuration _getTemplateItemConfiguration(String itemId, NewsletterTemplate template) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", itemId);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.ribbon.element.ui.ButtonController");
        DefaultConfiguration enableToggleConf = new DefaultConfiguration("toggle-enabled");
        enableToggleConf.setValue("true");
        classConf.addChild((Configuration)enableToggleConf);
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        labelConf.setValue(this._i18nUtils.translate((I18nizable)template.getLabel()));
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration descConf = new DefaultConfiguration("description");
        descConf.setValue(this._i18nUtils.translate((I18nizable)template.getDescription()));
        classConf.addChild((Configuration)descConf);
        DefaultConfiguration nameConf = new DefaultConfiguration("name");
        nameConf.setValue(template.getId());
        classConf.addChild((Configuration)nameConf);
        DefaultConfiguration iconSmallConf = new DefaultConfiguration("icon-small");
        iconSmallConf.setValue(template.getSmallImage());
        classConf.addChild((Configuration)iconSmallConf);
        DefaultConfiguration iconMediumConf = new DefaultConfiguration("icon-medium");
        iconMediumConf.setValue(template.getMediumImage());
        classConf.addChild((Configuration)iconMediumConf);
        DefaultConfiguration iconLargeConf = new DefaultConfiguration("icon-large");
        iconLargeConf.setValue(template.getLargeImage());
        classConf.addChild((Configuration)iconLargeConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        return conf;
    }
}

