/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.content;

import java.util.Arrays;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.plugins.repository.data.extractor.xml.ModelLessXMLValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentExtractor
extends org.ametys.web.content.ContentExtractor {
    public static final String NEWSLETTER_CONTENT_EXTACTOR_ROLE = ContentExtractor.class.getName();
    private static final String __CATEGORY_METADATA_NAME = "category";
    private static final String __AUTOMATIC_METADATA_NAME = "automatic";
    private static final String __SENT_METADATA_NAME = "sent";
    private ModelItemTypeExtensionPoint _metadataTypesExtensionPoints;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._metadataTypesExtensionPoints = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_MODEL_LESS_BASIC);
    }

    public void fillContent(ModifiableContent content, Node node, XMLValuesExtractorAdditionalDataGetter additionalDataGetter) throws Exception {
        super.fillContent(content, node, additionalDataGetter);
        if (Arrays.asList(content.getTypes()).contains("org.ametys.plugins.newsletter.Content.newsletter")) {
            Element contentElement = (Element)XPathAPI.selectSingleNode((Node)node, (String)"content");
            this.fillMetadata(content, contentElement, additionalDataGetter);
        }
    }

    protected void fillMetadata(ModifiableContent content, Element contentElement, XMLValuesExtractorAdditionalDataGetter additionalDataGetter) throws Exception {
        ModifiableModelLessDataHolder internalDataHolder = content.getInternalDataHolder();
        ModelLessXMLValuesExtractor valuesExtractor = new ModelLessXMLValuesExtractor(contentElement, additionalDataGetter, (AbstractThreadSafeComponentExtensionPoint)this._metadataTypesExtensionPoints);
        Object category = valuesExtractor.extractValue(__CATEGORY_METADATA_NAME);
        internalDataHolder.setValue(__CATEGORY_METADATA_NAME, category);
        Object automatic = valuesExtractor.extractValue(__AUTOMATIC_METADATA_NAME);
        internalDataHolder.setValue(__AUTOMATIC_METADATA_NAME, automatic);
        Object sent = valuesExtractor.extractValue(__SENT_METADATA_NAME);
        internalDataHolder.setValue(__SENT_METADATA_NAME, sent);
    }
}

