/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.daos;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class SubscribersDAO
extends AbstractMyBatisDAO
implements ThreadSafe {
    public static final String ROLE = SubscribersDAO.class.getName();
    private static final Map<String, String> __ORDER_TO_COL_MAPPING = Map.of("email", "Email", "siteName", "Site_Name", "categoryId", "Category", "subscribedAt", "Subscribed_At", "token", "Token");

    private List<Subscriber> _getSubscribers(Map<String, Object> params) {
        return this._getSubscribers(params, null);
    }

    private List<Subscriber> _getSubscribers(Map<String, Object> params, List<Map<String, Object>> sorts) {
        return this._getSubscribers(params, sorts, RowBounds.DEFAULT);
    }

    private List<Subscriber> _getSubscribers(Map<String, Object> params, List<Map<String, Object>> sorts, RowBounds rowBounds) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(params);
        if (sorts != null) {
            StringBuilder sortString = new StringBuilder();
            for (Map map : sorts) {
                String property = (String)map.get("property");
                sortString.append(__ORDER_TO_COL_MAPPING.getOrDefault(property, property));
                sortString.append(" ");
                sortString.append(Optional.of("direction").map(map::get).orElse("ASC"));
                sortString.append(",");
            }
            if (!sorts.isEmpty()) {
                sortString.deleteCharAt(sortString.length() - 1);
                queryParams.put("__order", sortString.toString());
            }
        }
        try (SqlSession session = this.getSession();){
            List list = session.selectList("Subscribers.getSubscribers", queryParams, rowBounds);
            return list;
        }
    }

    public List<Subscriber> getSubscribers() {
        return this._getSubscribers(Map.of());
    }

    public List<Subscriber> getSubscribers(List<Map<String, Object>> sorts) {
        return this._getSubscribers(Map.of(), sorts);
    }

    public List<Subscriber> getSubscribers(String siteName, String categoryId) {
        return this._getSubscribers(Map.of("siteName", siteName, "category", categoryId));
    }

    public List<Subscriber> getSubscribers(String siteName, String categoryId, List<Map<String, Object>> sorts, int offset, int limit) {
        return this._getSubscribers(Map.of("siteName", siteName, "category", categoryId), sorts, new RowBounds(offset, limit));
    }

    public int getSubscribersCount(String siteName, String categoryId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteName", siteName);
        params.put("category", categoryId);
        try (SqlSession session = this.getSession();){
            int n = (Integer)session.selectOne("Subscribers.getSubscribersCount", params);
            return n;
        }
    }

    public Subscriber getSubscriber(String email, String siteName, String categoryId) {
        return this._getSubscribers(Map.of("email", email, "siteName", siteName, "category", categoryId)).stream().findFirst().orElse(null);
    }

    public Subscriber getSubscriberByToken(String token) {
        return this._getSubscribers(Map.of("token", token)).stream().findFirst().orElse(null);
    }

    public List<Subscriber> getSubscriptions(String email, String siteName) {
        return this._getSubscribers(Map.of("email", email, "siteName", siteName));
    }

    public void subscribe(Subscriber subscriber) {
        try (SqlSession session = this.getSession(true);){
            session.insert("Subscribers.subscribe", (Object)subscriber);
        }
    }

    public void subscribe(Collection<Subscriber> subscribers) {
        try (SqlSession session = this.getSession();){
            for (Subscriber subscriber : subscribers) {
                session.insert("Subscribers.subscribe", (Object)subscriber);
            }
            session.commit();
        }
    }

    public void modifySubscriptions(Collection<Subscriber> newSubscribers, Collection<String> removeSubscriptions, UnsubscribeOrigin origin) {
        try (SqlSession session = this.getSession();){
            for (Subscriber subscriber : newSubscribers) {
                session.insert("Subscribers.subscribe", (Object)subscriber);
            }
            for (String tokenToRemove : removeSubscriptions) {
                Subscriber subscriber = this.getSubscriberByToken(tokenToRemove);
                if (subscriber == null) continue;
                session.update("Subscribers.unsubscribe", (Object)tokenToRemove);
                ForensicLogger.info((String)"newsletter.unsubscribe", Map.of("email", subscriber.getEmail(), "siteName", subscriber.getSiteName(), "category", subscriber.getCategoryId(), "origin", origin.name()), null);
            }
            session.commit();
        }
    }

    public void unsubscribe(String token, UnsubscribeOrigin origin) {
        try (SqlSession session = this.getSession(true);){
            Subscriber subscriber = this.getSubscriberByToken(token);
            if (subscriber != null) {
                session.update("Subscribers.unsubscribe", (Object)token);
                ForensicLogger.info((String)"newsletter.unsubscribe", Map.of("email", subscriber.getEmail(), "siteName", subscriber.getSiteName(), "category", subscriber.getCategoryId(), "origin", origin.name()), null);
            }
        }
    }

    public void empty(String categoryId, String siteName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("categoryId", categoryId);
        params.put("siteName", siteName);
        try (SqlSession session = this.getSession(true);){
            session.delete("Subscribers.empty", params);
        }
    }

    public int unsubscribe(String email, String siteName, UnsubscribeOrigin origin) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        params.put("siteName", siteName);
        try (SqlSession session = this.getSession(true);){
            int result = session.delete("Subscribers.removeSubscriptionsByEmail", params);
            if (result > 0) {
                ForensicLogger.info((String)"newsletter.unsubscribe", Map.of("email", email, "siteName", siteName, "origin", origin.name()), null);
            }
            int n = result;
            return n;
        }
    }

    public static enum UnsubscribeOrigin {
        SUBSCRIBER,
        ADMINISTRATOR,
        DATAPOLICY;

    }
}

