/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.config.Config;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class SubscriberDataPolicy
implements PersonalDataPolicy,
Serviceable {
    protected PopulationContextHelper _populationContextHelper;
    protected SiteManager _siteManager;
    protected SubscribersDAO _subscribersDao;
    protected UserManager _userManager;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._subscribersDao = (SubscribersDAO)((Object)manager.lookup(SubscribersDAO.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        Long config = (Long)Config.getInstance().getValue("runtime.data.policy.userpref.retention", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        if (this._retentionPeriod != null && userStatusInfo.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) {
            long deletedSubscriptions = 0L;
            String email = userStatusInfo.getEmail();
            if (StringUtils.isNotBlank((CharSequence)email)) {
                try (AmetysObjectIterable sites = this._siteManager.getSites();){
                    for (Site site : sites) {
                        String siteName = site.getName();
                        Set userPopulationsOnSite = this._populationContextHelper.getUserPopulationsOnContexts(Arrays.asList("/sites/" + siteName, "/sites-fo/" + siteName), false, false);
                        try {
                            if (this._userManager.getUserByEmail(userPopulationsOnSite, email) != null) continue;
                            deletedSubscriptions += (long)this._subscribersDao.unsubscribe(email, siteName, SubscribersDAO.UnsubscribeOrigin.DATAPOLICY);
                        }
                        catch (NotUniqueUserException notUniqueUserException) {}
                    }
                }
            }
            if (deletedSubscriptions > 0L) {
                ForensicLogger.info((String)"data.policy.gdpr.remove.newsletter.subscriptions", Map.of("handled", Long.toString(deletedSubscriptions), "identity", userStatusInfo.getUserIdentity()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                return PersonalDataPolicy.AnonymizationResult.PROCESSED;
            }
            return PersonalDataPolicy.AnonymizationResult.NO_DATA;
        }
        return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
    }
}

