/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.userpref;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesStorage;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class NewsletterUserPreferencesStorage
extends AbstractLogEnabled
implements UserPreferencesStorage,
Component,
Serviceable {
    protected UserManager _foUserManager;
    protected CategoryProviderExtensionPoint _categoryEP;
    protected SiteManager _siteManager;
    protected SubscribersDAO _subscribersDao;
    protected PopulationContextHelper _populationContextHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._foUserManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._categoryEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._subscribersDao = (SubscribersDAO)((Object)serviceManager.lookup(SubscribersDAO.ROLE));
    }

    public Map<String, String> getUnTypedUserPrefs(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        try {
            HashMap<String, String> preferenceValues = new HashMap<String, String>();
            User user = this._foUserManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            String siteName = contextVars.get("siteName");
            if (user != null && siteName != null) {
                List<Subscriber> subscriptions = this._subscribersDao.getSubscriptions(user.getEmail(), siteName);
                for (Subscriber subscription : subscriptions) {
                    preferenceValues.put(subscription.getCategoryId(), "true");
                }
            }
            return preferenceValues;
        }
        catch (Exception e) {
            String message = "Error getting newsletter user preferences for login " + String.valueOf(userIdentity) + " and context " + storageContext;
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, (Throwable)e);
        }
    }

    public void setUserPreferences(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        try {
            User user = this._foUserManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            String siteName = contextVars.get("siteName");
            if (user != null && siteName != null) {
                ArrayList<Subscriber> newSubscribers = new ArrayList<Subscriber>();
                HashSet<String> removeTokens = new HashSet<String>();
                Map<String, String> existingCategoryIds = this.getExistingCategoryIds(user.getEmail(), siteName);
                for (String categoryId : preferences.keySet()) {
                    String value = preferences.get(categoryId);
                    if (value.equals("true") && this._categoryEP.hasCategory(categoryId) && !existingCategoryIds.containsKey(categoryId)) {
                        Subscriber subscriber = this.getSubscription(siteName, user, categoryId);
                        newSubscribers.add(subscriber);
                        continue;
                    }
                    if (value.equals("true") || !this._categoryEP.hasCategory(categoryId) || !existingCategoryIds.containsKey(categoryId)) continue;
                    String token = existingCategoryIds.get(categoryId);
                    removeTokens.add(token);
                }
                this._subscribersDao.modifySubscriptions(newSubscribers, removeTokens, SubscribersDAO.UnsubscribeOrigin.SUBSCRIBER);
            }
        }
        catch (Exception e) {
            String message = "Error setting newsletter user preferences for login " + String.valueOf(userIdentity) + " and context " + storageContext;
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, (Throwable)e);
        }
    }

    public void removeUserPreferences(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        block12: {
            try {
                String email;
                User user = this._foUserManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
                if (user == null || (email = user.getEmail()) == null) break block12;
                String siteName = contextVars.get("siteName");
                if (siteName != null) {
                    this._subscribersDao.unsubscribe(email, storageContext, SubscribersDAO.UnsubscribeOrigin.DATAPOLICY);
                    break block12;
                }
                try (AmetysObjectIterable sites = this._siteManager.getSites();){
                    for (Site site : sites) {
                        siteName = site.getName();
                        Set userPopulationsOnSite = this._populationContextHelper.getUserPopulationsOnContexts(Arrays.asList("/sites/" + siteName, "/sites-fo/" + siteName), false, false);
                        try {
                            if (this._foUserManager.getUserByEmail(userPopulationsOnSite, email) != null) continue;
                            this._subscribersDao.unsubscribe(email, siteName, SubscribersDAO.UnsubscribeOrigin.DATAPOLICY);
                        }
                        catch (NotUniqueUserException notUniqueUserException) {}
                    }
                }
            }
            catch (Exception e) {
                String message = "Error removing newsletter subscriptions for login " + String.valueOf(userIdentity) + " and context " + storageContext;
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, (Throwable)e);
            }
        }
    }

    public String getUserPreferenceAsString(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        String value = null;
        Boolean booleanValue = this.getUserPreferenceAsBoolean(userIdentity, storageContext, contextVars, id);
        if (booleanValue != null) {
            value = booleanValue.toString();
        }
        return value;
    }

    public Long getUserPreferenceAsLong(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    public ZonedDateTime getUserPreferenceAsDate(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    public Boolean getUserPreferenceAsBoolean(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        try {
            Boolean value = null;
            User user = this._foUserManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            String siteName = contextVars.get("siteName");
            if (user != null && siteName != null) {
                Subscriber subscriber = this._subscribersDao.getSubscriber(user.getEmail(), siteName, id);
                value = subscriber != null;
            }
            return value;
        }
        catch (Exception e) {
            throw new UserPreferencesException("Error getting newsletter user preferences for login " + String.valueOf(userIdentity) + " and context " + storageContext, (Throwable)e);
        }
    }

    public Double getUserPreferenceAsDouble(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    protected Subscriber getSubscription(String siteName, User user, String categoryId) {
        return this.getSubscription(siteName, user, categoryId, true);
    }

    protected Subscriber getSubscription(String siteName, User user, String categoryId, boolean generateDateAndToken) {
        Subscriber subscriber = new Subscriber();
        subscriber.setEmail(user.getEmail());
        subscriber.setSiteName(siteName);
        subscriber.setCategoryId(categoryId);
        if (generateDateAndToken) {
            subscriber.setSubscribedAt(new Date());
            String token = UUID.randomUUID().toString();
            subscriber.setToken(token);
        }
        return subscriber;
    }

    protected Map<String, String> getExistingCategoryIds(String email, String siteName) {
        HashMap<String, String> existingCategoryIds = new HashMap<String, String>();
        List<Subscriber> existingSubscriptions = this._subscribersDao.getSubscriptions(email, siteName);
        for (Subscriber subscription : existingSubscriptions) {
            existingCategoryIds.put(subscription.getCategoryId(), subscription.getToken());
        }
        return existingCategoryIds;
    }
}

