/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.workflow;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.util.mail.SendMailHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailEngine
implements Runnable {
    private static Logger _logger = LoggerFactory.getLogger(SendMailEngine.class);
    private static final Random _RNG = new Random((long)Math.random() * System.nanoTime());
    private String _subject;
    private String _htmlBody;
    private String _textBody;
    private Map<String, String> _recipients;
    private String _sender;
    private boolean _parametrized;

    public void parameterize(String subject, String htmlBody, String textBody, Map<String, String> recipients, String sender) {
        this._subject = subject;
        this._htmlBody = SendMailHelper.inlineCSS((String)htmlBody);
        this._textBody = textBody;
        this._recipients = recipients;
        this._sender = sender;
        this._parametrized = true;
    }

    private void _checkParametrization() {
        if (!this._parametrized) {
            String message = "The mail engine component has to be parameterized before it can be run.";
            _logger.error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public void run() {
        this._checkParametrization();
        if (_logger.isInfoEnabled()) {
            _logger.info("Try to send " + this._recipients.size() + " mails at " + String.valueOf(new Date()));
        }
        for (String recipient : this._recipients.keySet()) {
            try {
                String htmlBody = this._htmlBody.replaceAll("#token#", this._recipients.get(recipient));
                String textBody = this._textBody.replaceAll("#token#", this._recipients.get(recipient));
                Pattern pattern = Pattern.compile("\\#random_number_token#");
                Matcher m = pattern.matcher(htmlBody);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(sb, Integer.toString(_RNG.nextInt(Integer.MAX_VALUE)));
                }
                m.appendTail(sb);
                SendMailHelper.newMail().withSubject(this._subject).withHTMLBody(sb.toString()).withInlineCSS(false).withTextBody(textBody).withSender(this._sender).withRecipient(recipient).sendMail();
                Thread.sleep(1000L);
            }
            catch (MessagingException | IOException e) {
                _logger.error("Mail failed !", e);
            }
            catch (InterruptedException e) {
                _logger.error("Error while waiting for sending mails", (Throwable)e);
            }
        }
        if (_logger.isInfoEnabled()) {
            _logger.info("All mails are sent at " + String.valueOf(new Date()));
        }
    }
}

