/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.plugins.newsletter.NewsletterDAO;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.plugins.newsletter.workflow.SendWebAnalyticsEventsEngine;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.content.jcr.DefaultWebContent;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class SendNewsletterFunction
extends AbstractContentWorkflowComponent
implements EnhancedFunction,
Contextualizable {
    private SubscribersDAO _subscribersDAO;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private Context _context;
    private NewsletterDAO _newsletterDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._subscribersDAO = (SubscribersDAO)((Object)manager.lookup(SubscribersDAO.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._newsletterDAO = (NewsletterDAO)((Object)manager.lookup(NewsletterDAO.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Request request = this._getRequest();
        if (request.getParameter("send") == null && request.getAttribute("send") == null) {
            return;
        }
        DefaultWebContent content = (DefaultWebContent)this.getContent(transientVars);
        try {
            String categoryID = (String)content.getInternalDataHolder().getValue("category");
            String siteName = content.getSiteName();
            Site site = content.getSite();
            boolean descending = (Boolean)site.getValue("newsletter-subscription-descending", false, (Object)false);
            boolean ascending = (Boolean)site.getValue("newsletter-subscription-ascending", false, (Object)false);
            List<Subscriber> subscribers = this._subscribersDAO.getSubscribers(content.getSiteName(), (String)content.getInternalDataHolder().getValue("category"));
            if (descending) {
                subscribers.addAll(this._getSubscribersOfParentCategories(categoryID, siteName));
            }
            if (ascending) {
                subscribers.addAll(this._getSubscribersOfChildCategories(categoryID, siteName));
            }
            HashMap<String, String> recipients = new HashMap<String, String>();
            for (Subscriber subcriber : subscribers) {
                recipients.put(subcriber.getEmail(), subcriber.getToken());
            }
            this._newsletterDAO.sendNewsletter(content, recipients);
            content.getInternalDataHolder().setValue("sent", (Object)true);
            try {
                this._newsletterDAO.removeTestNewsletter((WebContent)content, site);
            }
            catch (RepositoryException e) {
                this._logger.warn("Unable to remove the temporary test newsletter.", (Throwable)e);
            }
            content.saveChanges();
            SendWebAnalyticsEventsEngine sendGaEngine = new SendWebAnalyticsEventsEngine();
            sendGaEngine.initialize(this._manager, this._context);
            sendGaEngine.parametrize(siteName, (WebContent)content, this._newsletterDAO.getCategory(categoryID), recipients.size());
            new Thread(sendGaEngine).start();
        }
        catch (IOException e) {
            throw new WorkflowException("Unable to send mails !", (Throwable)e);
        }
        catch (ContextException e) {
            this._logger.warn("Context exception when initializing an engine.", (Throwable)e);
        }
        catch (ServiceException e) {
            this._logger.warn("Service exception when initializing an engine.", (Throwable)e);
        }
    }

    protected List<Subscriber> _getSubscribersOfParentCategories(String categoryID, String siteName) {
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        Category category = this._newsletterDAO.getCategory(categoryID);
        Category parentCategory = this._newsletterDAO.getCategory(category.getParentId());
        while (parentCategory != null) {
            subscribers.addAll(this._subscribersDAO.getSubscribers(siteName, parentCategory.getId()));
            parentCategory = this._newsletterDAO.getCategory(parentCategory.getParentId());
        }
        return subscribers;
    }

    protected List<Subscriber> _getSubscribersOfChildCategories(String categoryID, String siteName) {
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        CategoryProvider provider = this._getProvider(categoryID);
        List<Category> children = provider.getCategories(categoryID);
        for (Category child : children) {
            subscribers.addAll(this._subscribersDAO.getSubscribers(siteName, child.getId()));
            subscribers.addAll(this._getSubscribersOfChildCategories(child.getId(), siteName));
        }
        return subscribers;
    }

    protected Request _getRequest() {
        return ContextHelper.getRequest((Context)this._context);
    }

    protected CategoryProvider _getProvider(String categoryID) {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String id : ids) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            if (!provider.hasCategory(categoryID)) continue;
            return provider;
        }
        return null;
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.POST;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_SEND_NEWSLETTER_FUNCTION_LABEL");
    }
}

