/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.workflow;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.analytics.WebAnalyticsProvider;
import org.ametys.web.analytics.WebAnalyticsProviderExtensionPoint;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendWebAnalyticsEventsEngine
implements Runnable {
    private static final Logger _LOGGER = LoggerFactory.getLogger(SendWebAnalyticsEventsEngine.class);
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _environmentContext;
    protected ServiceManager _manager;
    protected boolean _initialized;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected SiteManager _siteManager;
    protected WebAnalyticsProviderExtensionPoint _webAnalyticsProviderEP;
    protected I18nUtils _i18nUtils;
    protected AmetysObjectResolver _resolver;
    private boolean _parametrized;
    private Site _site;
    private LocalDate _newsletterDate;
    private long _newsletterNumber;
    private String _newsletterTitle;
    private Category _category;
    private int _eventCount;

    public void initialize(ServiceManager manager, org.apache.avalon.framework.context.Context context) throws ContextException, ServiceException {
        this._manager = manager;
        this._context = context;
        this._environmentContext = (Context)context.get((Object)"environment-context");
        this._webAnalyticsProviderEP = (WebAnalyticsProviderExtensionPoint)manager.lookup(WebAnalyticsProviderExtensionPoint.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._initialized = true;
    }

    public void parametrize(String siteName, WebContent newsletterContent, Category category, int eventCount) {
        if (siteName != null) {
            this._site = this._siteManager.getSite(siteName);
        }
        this._category = category;
        this._eventCount = eventCount;
        this._newsletterDate = (LocalDate)newsletterContent.getValue("newsletter-date");
        this._newsletterNumber = (Long)newsletterContent.getValue("newsletter-number", false, (Object)0L);
        this._newsletterTitle = (String)newsletterContent.getValue("title", false, (Object)"");
        this._parametrized = true;
    }

    private void _checkInitialization() {
        if (!this._initialized) {
            String message = "The web analytics events engine has to be properly initialized before it's run.";
            _LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        if (!this._parametrized) {
            String message = "The web analytics events engine has to be parametrized before it's run.";
            _LOGGER.error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public void run() {
        this._checkInitialization();
        if (_LOGGER.isInfoEnabled()) {
            _LOGGER.info("Starting to send web analytics newsletter events.");
        }
        this.sendEvents();
        if (_LOGGER.isInfoEnabled()) {
            _LOGGER.info("All mails are sent at " + String.valueOf(new Date()));
        }
    }

    protected void sendEvents() {
        String trackingProviderId;
        Site site = (Site)this._resolver.resolveById(this._site.getId());
        if (((Boolean)site.getValue("newsletter-enable-tracking", false, (Object)true)).booleanValue() && this._webAnalyticsProviderEP.hasExtension(trackingProviderId = (String)site.getValue("tracking-provider", true, (Object)""))) {
            try {
                WebAnalyticsProvider provider = (WebAnalyticsProvider)this._webAnalyticsProviderEP.getExtension(trackingProviderId);
                String category = this._getNewsletterCategory();
                String label = this._getNewsletterLabel();
                for (int i = 0; i < this._eventCount; ++i) {
                    String uri = provider.getEventImageUri(site, category, "Sending", label, 0, false);
                    if (!StringUtils.isNotBlank((CharSequence)uri)) continue;
                    try {
                        if (i > 0) {
                            Thread.sleep(1100L);
                        }
                        this.sendEvent(uri);
                        continue;
                    }
                    catch (IOException e) {
                        _LOGGER.error("IO error sending the event.", (Throwable)e);
                        continue;
                    }
                    catch (InterruptedException e) {
                        _LOGGER.error("Error while waiting for sending mails.", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void sendEvent(String eventUrl) throws IOException {
        URL url = new URL(eventUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "Ametys/3 (compatible; MSIE 6.0)");
        connection.setRequestMethod("GET");
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            _LOGGER.error("Web analytics image request returned with error (code: " + responseCode + ").");
        } else {
            this.consumeQuietly(connection.getInputStream());
        }
    }

    private String _getNewsletterCategory() {
        String newsletterTitle = this._i18nUtils.translate((I18nizable)this._category.getTitle(), this._category.getLang());
        return "Newsletters/" + newsletterTitle;
    }

    private String _getNewsletterLabel() {
        StringBuilder label = new StringBuilder();
        label.append(this._newsletterTitle);
        if (this._newsletterNumber > 0L) {
            label.append("-").append(this._newsletterNumber);
        }
        if (this._newsletterDate != null) {
            label.append("-").append(this._newsletterDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        return label.toString();
    }

    protected void consumeQuietly(InputStream input) {
        try {
            byte[] buffer = new byte[256];
            while (input.read(buffer) != -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

