<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
				xmlns:math="java.lang.Math"
                extension-element-prefixes="math">

    <xsl:import href="service:web://pages/services/common.xsl"/>    

	<xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
	
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="captchaType" select="ametys:config('runtime.captcha.type')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">newsletter newsletter-subscribe</xsl:variable>
    <xsl:variable name="is-empty" select="not(/NewsletterService)"/>
    <xsl:variable name="common-service-name">service-newsletter-subscribe</xsl:variable>          
    
    
    <!-- +
         | HEAD
         + -->    

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>
            <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIBE_FORM_TITLE" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                
        </xsl:call-template>
    </xsl:template>     
    
    
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
            <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_DESCRIPTION" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                           
        </xsl:call-template>
    </xsl:template>

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
    
        <xsl:choose>
            <xsl:when test="/NewsletterService/FormResult/msg = 'success'">
                <xsl:call-template name="success"/>
            </xsl:when>
            <xsl:when test="/NewsletterService/FormResult/msg = 'failure'">
                <xsl:call-template name="failure"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Form -->
                <xsl:call-template name="subscribe-form"/>
            </xsl:otherwise>
        </xsl:choose>
        
        <!-- Legal mentions -->
        <xsl:call-template name="mentions"/>
    </xsl:template>    
    
    <!-- Template to display the success message -->
	<xsl:template name="success">
		<div class="info">
			<p>
                <xsl:if test="/NewsletterService/FormResult/subscribeTo">
    				<xsl:variable name="id" select="/NewsletterService/FormResult/subscribeTo"/>
    				<i18n:translate>
    					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_SUCCESS_SINGLE"/>
    					<i18n:param><xsl:value-of select="/NewsletterService/FormResult/email"/></i18n:param>
    					<i18n:param><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></i18n:param>
    				</i18n:translate>
    			</xsl:if>
    			
    			<xsl:if test="/NewsletterService/FormResult/alreadySubscribeTo">
    				<xsl:variable name="id" select="/NewsletterService/FormResult/alreadySubscribeTo"/>
    				<i18n:translate>
    					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_ALREADY_REGISTERED_SINGLE"/>
    					<i18n:param><xsl:value-of select="/NewsletterService/FormResult/email"/></i18n:param>
    					<i18n:param><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></i18n:param>
    				</i18n:translate>
    			</xsl:if>
            </p>
		</div>
	</xsl:template>
	
	<!-- Template to display the server error message -->
    <xsl:template name="failure">
        <div class="error">
            <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_EMAIL_SERVER_ERROR"/></p>
        </div>
    </xsl:template>
	
	<!-- NOT USED.  -->
	<xsl:template name="success-multiple">
		<div class="info">
			<xsl:if test="/NewsletterService/FormResult/subscribeTo">
				<p>
                    <i18n:translate>
    					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_SUCCESS"/>
    					<i18n:param><xsl:value-of select="/NewsletterService/FormResult/email"/></i18n:param>
    				</i18n:translate>
                </p>
				<ul>
					<xsl:for-each select="/NewsletterService/FormResult/subscribeTo">
						<xsl:variable name="id" select="."/>
						<li><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
			
			<xsl:if test="/NewsletterService/FormResult/alreadySubscribeTo">
				<p>
                <i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_ALREADY_REGISTERED"/>
					<i18n:param><xsl:value-of select="/NewsletterService/FormResult/email"/></i18n:param>
				</i18n:translate>
                </p>
				<ul>
					<xsl:for-each select="/NewsletterService/FormResult/alreadySubscribeTo">
						<xsl:variable name="id" select="."/>
						<li><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
		</div>
	</xsl:template>
	
    <!-- Template used by subscribe form -->
	<xsl:template name="subscribe-form">
        <xsl:call-template name="subscribe-form-hint"/>
        
        <xsl:call-template name="errors-message"/>
        
		<form action="" method="post">
			<div>
	            <!-- category -->
	            <input type="hidden" name="category" value="{/NewsletterService/Categories/category/@id}"/>
	            
	            <!-- page id -->
                <input type="hidden" name="page-id" value="{ametys:pageId()}"/>
                <input type="hidden" name="zoneitem-id" value="{ametys:zoneItemId()}"/>
                
	            <!-- email -->
	            <div class="field">
	                <div class="label">
	                    <label for="subscribe-email-{$uniqueId}">
	                    	<i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL_LABEL"/>
							<span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
	                    </label>          
	                </div>
	                <div>
	                	<xsl:attribute name="class">
	                		<xsl:text>input</xsl:text>
		                    <xsl:if test="/NewsletterService/FormResult/msg = 'invalid-email'">
		                        <xsl:text> invalid</xsl:text>
		                    </xsl:if>
	                    </xsl:attribute>
	                    
	                    <xsl:choose>
	                       <xsl:when test="/NewsletterService/FormResult/email">
                               <input type="text" name="email" class="text" id="subscribe-email-{$uniqueId}" value="{/NewsletterService/FormResult/email}"/>
                           </xsl:when>
	                       <xsl:otherwise>
           	                   <input type="text" name="email" class="text" id="subscribe-email-{$uniqueId}" value="{/NewsletterService/user/email}"/>
                           </xsl:otherwise>
	                    </xsl:choose>
	                </div>
	                <div class="field-end"></div>
	            </div>
				
				
				<xsl:if test="/NewsletterService/FormResult/has-captcha = 'true'">
					<!-- captcha -->
		            <div class="field">
                        <xsl:if test="captcha:requiresUserInteraction()">
    		                <div class="label">
    		                    <label for="captcha-{$uniqueId}">
    		                    	<i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_LABEL"/>
    			                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>      
    		                    </label>
    		                </div>
                        </xsl:if>
		                <div class="input">
		                    <xsl:if test="FormResult/msg = 'invalid'">
		                        <xsl:attribute name="class">invalid</xsl:attribute>
		                    </xsl:if>
		
		                    <xsl:call-template name="captcha">
		                        <xsl:with-param name="key-name" select="'captcha-key'"/>
		            
		                        <xsl:with-param name="value-name" select="'captcha'"/>
		                        <xsl:with-param name="value-id" select="concat('captcha-', $uniqueId)"/>
		                        <xsl:with-param name="value-class">captcha</xsl:with-param>
		            
		                        <xsl:with-param name="image-alt"/>
		                        <xsl:with-param name="image-alt-i18n" select="false()"/>
		                        <xsl:with-param name="image-class">captcha-image</xsl:with-param>
		                        
		                        <xsl:with-param name="contextPath"><xsl:value-of select="$uri-prefix"/></xsl:with-param>
		                    </xsl:call-template>                
		                </div>
		                <div class="field-end"></div>
		            </div>
		        </xsl:if>
	                        
				<input type="hidden" name="subscribe"/>
				<input type="hidden" name="siteName" value="{$site}"/>
				
	            <!-- Template for submit button -->
	            <xsl:call-template name="common-utils-input-submit">
	                <xsl:with-param name="class-name">subscribe</xsl:with-param>
	                <xsl:with-param name="i18nkey" select="'plugin.newsletter:NEWSLETTERS_SERVICE_INPUT_SUBMIT'" />                
	            </xsl:call-template>
	    	</div>
		</form>
	</xsl:template>
    
    <!-- Template used to display the introductory text to subscribe  -->
    <xsl:template name="subscribe-form-hint">    
        <p>
            <i18n:translate>
                <i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIBE_FORM_HINT"/>
                <i18n:param><xsl:value-of select="/NewsletterService/Categories/category/title"/></i18n:param>
            </i18n:translate>
        </p>    
        <p class="mandatory-hint">
        	<i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
        </p>
    </xsl:template>
	
    <!-- Template used to display category of newsletters -->
	<xsl:template match="category">
		<xsl:param name="indent">0</xsl:param>
		
		<xsl:variable name="id" select="@id"/>
		<div class="field checkbox">
            <div class="input">
                <input type="checkbox" name="category" value="{@id}" id="category_{$uniqueId}_{position()}" style="margin-left: {$indent}px">
                    <xsl:if test="/NewsletterService/FormResult/category[. = $id]">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                    </xsl:if>
                </input>            
            </div>
            <div class="label">
                <label for="category_{$uniqueId}_{position()}"><xsl:value-of select="title"/></label>
                <xsl:if test="description != ''">
                    <span class="description">(<xsl:value-of select="description"/>)</span>
                </xsl:if>            
            </div>            
        </div>
		
		<xsl:apply-templates select="category">
			<xsl:with-param name="indent" select="$indent + 20"/>
		</xsl:apply-templates>
		
	</xsl:template>
	
    <!-- Template used to display mentions -->
	<xsl:template name="mentions">
		<div class="mentions">
	        <i18n:text i18n:key="NEWSLETTERS_SERVICE_LEGAL_MENTIONS"/>
		</div>
	</xsl:template>

    <xsl:template name="errors-message">
        <xsl:variable name="error-invalid-email" select="/NewsletterService/FormResult/msg = 'invalid-email'"/>
        <xsl:variable name="error-already-exists" select="/NewsletterService/FormResult/msg = 'already-exist'"/>
        <xsl:variable name="error-invalid-captcha" select="/NewsletterService/FormResult/msg = 'invalid-captcha'"/>

        <xsl:if test="$error-invalid-email or $error-already-exists or $error-invalid-captcha">
        	<div class="error">
	        	<p><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_ERRORS" i18n:catalogue="plugin.newsletter"/></p>
	        	<ul>
			     	<xsl:if test="$error-invalid-email">
			            <xsl:call-template name="error-message">
			                  <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>
			            </xsl:call-template>
					</xsl:if>
					<xsl:if test="$error-already-exists">
			            <xsl:call-template name="error-message">
			                 <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_EMAIL_ALREADY_EXISTS" i18n:catalogue="plugin.newsletter"/></xsl:with-param>
			            </xsl:call-template>            
					</xsl:if>
					<xsl:if test="$error-invalid-captcha">
                        <xsl:choose>
                            <xsl:when test="captcha:requiresUserInteraction()">
                                <xsl:call-template name="error-message">
                                    <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                
                                </xsl:call-template>  
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="error-message">
                                    <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_RECAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                
                                </xsl:call-template>  
                            </xsl:otherwise>
                        </xsl:choose>
					</xsl:if>
				</ul>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="error-message">
        <xsl:param name="i18nkey" />
        
        <li>
            <xsl:copy-of select="$i18nkey"/>
        </li>
    </xsl:template>
    

</xsl:stylesheet>
