/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.category;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.observation.AbstractNotifierAction;

/**
 * Apply a template to a given newsletter category
 */
public class ApplyTemplatesAction extends AbstractNotifierAction
{
    private CategoryProviderExtensionPoint _categoryProviderEP;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _categoryProviderEP = (CategoryProviderExtensionPoint) smanager.lookup(CategoryProviderExtensionPoint.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> jsParameters = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        
        @SuppressWarnings("unchecked")
        List<String> ids = (List<String>) jsParameters.get("id");
        String template = (String) jsParameters.get("template");

        Set<String> providerIDs = _categoryProviderEP.getExtensionsIds();
        
        for (String id : ids)
        {
            for (String providerID : providerIDs)
            {
                CategoryProvider provider = _categoryProviderEP.getExtension(providerID);
                if (provider.hasCategory(id))
                {
                    Category category = provider.getCategory(id);
                    provider.setTemplate(category, template);
                }
                
            }
        }
        
        return EMPTY_MAP;
    }
   
}
