/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.JCRCategory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class JCRCategoryProvider
implements LogEnabled,
CategoryProvider,
Serviceable,
Configurable,
PluginAware {
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected String _pluginName;
    protected String _featureName;
    protected Logger _logger;
    private AmetysObjectResolver _resolver;
    private SiteManager _siteManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = this.configureLabel(configuration);
        this._description = this.configureDescription(configuration);
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public List<Category> getCategories(String siteName, String lang) {
        if (StringUtils.isEmpty((CharSequence)siteName)) {
            return null;
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            DefaultTraversableAmetysObject rootNode = (DefaultTraversableAmetysObject)this._getRootNode(siteName, lang);
            AmetysObjectIterable it = rootNode.getChildren();
            for (AmetysObject object : it) {
                if (!(object instanceof JCRCategory)) continue;
                JCRCategory jcrCategory = (JCRCategory)object;
                Category category = new Category(jcrCategory.getId(), jcrCategory.getName(), rootNode.getId(), new I18nizableText(jcrCategory.getTitle()), new I18nizableText(jcrCategory.getDescription()), jcrCategory.getTemplate(), siteName, lang);
                categories.add(category);
            }
        }
        catch (RepositoryException e) {
            this._logger.error("Unable to list the newsletter categories for site " + siteName + " and language " + lang, (Throwable)e);
        }
        return categories;
    }

    @Override
    public Collection<Category> getAllCategories(String siteName, String lang) {
        if (StringUtils.isEmpty((CharSequence)siteName)) {
            return null;
        }
        HashSet<Category> categories = new HashSet<Category>();
        try {
            TraversableAmetysObject rootNode = this._getRootNode(siteName, lang);
            this.addCategories(categories, rootNode, siteName, lang);
        }
        catch (RepositoryException e) {
            this._logger.error("Unable to list the newsletter categories for site " + siteName + " and language " + lang, (Throwable)e);
        }
        return categories;
    }

    protected void addCategories(Set<Category> categories, TraversableAmetysObject parentObject, String siteName, String lang) {
        AmetysObjectIterable it = parentObject.getChildren();
        for (AmetysObject object : it) {
            if (!(object instanceof JCRCategory)) continue;
            JCRCategory jcrCategory = (JCRCategory)object;
            Category category = new Category(jcrCategory.getId(), jcrCategory.getName(), parentObject.getId(), new I18nizableText(jcrCategory.getTitle()), new I18nizableText(jcrCategory.getDescription()), jcrCategory.getTemplate(), siteName, lang);
            categories.add(category);
            this.addCategories(categories, (TraversableAmetysObject)jcrCategory, siteName, lang);
        }
    }

    @Override
    public Category getCategory(String categoryID) {
        try {
            JCRCategory category = (JCRCategory)this._resolver.resolveById(categoryID);
            AmetysObject parent = category.getParent();
            Object parentId = parent.getId();
            if (!(parent instanceof JCRCategory)) {
                parentId = "provider_" + this.getId();
            }
            return new Category(category.getId(), category.getName(), (String)parentId, new I18nizableText(category.getTitle()), new I18nizableText(category.getDescription()), category.getTemplate(), category.getSiteName(), category.getLang());
        }
        catch (UnknownAmetysObjectException e) {
            this._logger.warn("Unable to retrieve newsletter category of id " + categoryID, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setTemplate(Category category, String templateName) {
        JCRCategory jcrCategory = (JCRCategory)this._resolver.resolveById(category.getId());
        jcrCategory.setTemplate(templateName);
        jcrCategory.saveChanges();
    }

    @Override
    public Collection<String> getAutomaticIds(String categoryId) {
        JCRCategory jcrCategory = (JCRCategory)this._resolver.resolveById(categoryId);
        return jcrCategory.getAutomaticIds();
    }

    @Override
    public void setAutomatic(String categoryId, Collection<String> automaticNewsletterIds) {
        JCRCategory jcrCategory = (JCRCategory)this._resolver.resolveById(categoryId);
        jcrCategory.setAutomaticIds(automaticNewsletterIds);
        jcrCategory.saveChanges();
    }

    @Override
    public boolean hasCategory(String categoryID) {
        try {
            AmetysObject object = this._resolver.resolveById(categoryID);
            return object instanceof JCRCategory;
        }
        catch (UnknownAmetysObjectException e) {
            this._logger.debug("Unable to retrieve newsletter category of id " + categoryID, (Throwable)e);
            return false;
        }
        catch (AmetysRepositoryException e) {
            this._logger.debug("Unable to retrieve newsletter category of id " + categoryID, (Throwable)e);
            return false;
        }
    }

    @Override
    public List<Category> getCategories(String categoryID) {
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            JCRCategory category = (JCRCategory)this._resolver.resolveById(categoryID);
            AmetysObjectIterable it = category.getChildren();
            for (AmetysObject object : it) {
                if (!(object instanceof JCRCategory)) continue;
                JCRCategory jcrCategory = (JCRCategory)object;
                Category child = new Category(jcrCategory.getId(), jcrCategory.getName(), category.getId(), new I18nizableText(jcrCategory.getTitle()), new I18nizableText(jcrCategory.getDescription()), jcrCategory.getTemplate(), jcrCategory.getSiteName(), jcrCategory.getLang());
                categories.add(child);
            }
        }
        catch (AmetysRepositoryException e) {
            this._logger.error("Unable to list the newsletter categories for category of id " + categoryID, (Throwable)e);
        }
        return categories;
    }

    @Override
    public boolean hasChildren(String categoryID) {
        try {
            JCRCategory category = (JCRCategory)this._resolver.resolveById(categoryID);
            return category.getChildren().iterator().hasNext();
        }
        catch (AmetysRepositoryException e) {
            this._logger.error("Unable to retrieve newsletter category of id " + categoryID, (Throwable)e);
            return false;
        }
    }

    @Override
    public AmetysObjectIterable<Content> getNewsletters(String categoryID, String siteName, String lang) {
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.newsletter.Content.newsletter"});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName);
        StringExpression catExpr = new StringExpression("category", Expression.Operator.EQ, categoryID, ExpressionContext.newInstance().withInternal(true));
        AndExpression expr = new AndExpression(new Expression[]{cTypeExpr, siteExpr, catExpr});
        String xpathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr);
        return this._resolver.query(xpathQuery);
    }

    @Override
    public boolean hasNewsletters(String categoryID, String siteName, String lang) {
        ContentTypeExpression expr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.newsletter.Content.newsletter"});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName);
        expr = new AndExpression(new Expression[]{expr, siteExpr});
        StringExpression catExpr = new StringExpression("category", Expression.Operator.EQ, categoryID, ExpressionContext.newInstance().withInternal(true));
        expr = new AndExpression(new Expression[]{expr, catExpr});
        String xpathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr);
        return this._resolver.query(xpathQuery).iterator().hasNext();
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public String getId() {
        return this._id;
    }

    protected I18nizableText configureLabel(Configuration configuration) throws ConfigurationException {
        Configuration labelConfiguration = configuration.getChild("label");
        if (labelConfiguration.getAttributeAsBoolean("i18n", false)) {
            return new I18nizableText("plugin." + this._pluginName, labelConfiguration.getValue(""));
        }
        return new I18nizableText(labelConfiguration.getValue(""));
    }

    protected I18nizableText configureDescription(Configuration configuration) throws ConfigurationException {
        Configuration descConfiguration = configuration.getChild("description");
        if (descConfiguration.getAttributeAsBoolean("i18n", false)) {
            return new I18nizableText("plugin." + this._pluginName, descConfiguration.getValue(""));
        }
        return new I18nizableText(descConfiguration.getValue(""));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public String getRootId(String siteName, String lang) {
        try {
            return this._getRootNode(siteName, lang).getId();
        }
        catch (RepositoryException e) {
            this._logger.error("Unable to retrieve the root node of newsletter categories for site " + siteName + " and language " + lang, (Throwable)e);
            return null;
        }
    }

    private TraversableAmetysObject _getRootNode(String sitename, String lang) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(sitename).getRootPlugins();
        ModifiableTraversableAmetysObject categoriesNode = null;
        categoriesNode = !pluginsNode.hasChild("newsletter") ? (ModifiableTraversableAmetysObject)((ModifiableTraversableAmetysObject)pluginsNode.createChild("newsletter", "ametys:unstructured")).createChild("ametys:categories", "ametys:unstructured") : (ModifiableTraversableAmetysObject)pluginsNode.getChild("newsletter/ametys:categories");
        if (!categoriesNode.hasChild(lang)) {
            categoriesNode.createChild(lang, "ametys:unstructured");
            ((JCRAmetysObject)pluginsNode).getNode().getSession().save();
        }
        return (TraversableAmetysObject)pluginsNode.getChild("newsletter/ametys:categories/" + lang);
    }
}

