/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SubscribersGenerator
extends ServiceableGenerator {
    private SubscribersDAO _subscribersDao;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscribersDao = (SubscribersDAO)((Object)smanager.lookup(SubscribersDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = request.getParameter("siteName");
        String categoryId = request.getParameter("categoryID");
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"subscribers");
        List<Subscriber> subscribers = siteName != null && categoryId != null ? this._subscribersDao.getSubscribers(siteName, categoryId) : this._subscribersDao.getSubscribers();
        for (Subscriber subscriber : subscribers) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"subscriber");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"email", (String)subscriber.getEmail());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"siteName", (String)subscriber.getSiteName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"category", (String)subscriber.getCategoryId());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"subscribedAt", (String)DateUtils.dateToString((Date)subscriber.getSubscribedAt()));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"subscriber");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"subscribers");
        this.contentHandler.endDocument();
    }
}

