/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.testsending;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.URIUtils;
import org.apache.commons.lang3.StringUtils;

public final class HTMLExpertLinkResolver {
    private static final Pattern __PARSER = Pattern.compile("\\$\\{type:([^#]+)#url:([^#]+)#download:(true|false)\\}");

    private HTMLExpertLinkResolver() {
    }

    public static String parseAndResolve(String htmlexpert, String idDataHolderContent) {
        Object s = URIUtils.decode((String)htmlexpert);
        Matcher m = __PARSER.matcher((CharSequence)s);
        while (m.find()) {
            String type = m.group(1);
            Object uri = m.group(2);
            boolean download = "true".equals(m.group(3));
            if ("local".equals(type) && StringUtils.isNotEmpty((CharSequence)idDataHolderContent)) {
                uri = idDataHolderContent + "@" + StringUtils.substringAfter((String)uri, (String)"@");
                type = "newsletter-local";
            }
            s = ((String)s).substring(0, m.start()) + ResolveURIComponent.resolve((String)type, (String)uri, (boolean)download) + ((String)s).substring(m.end());
            m.reset((CharSequence)s);
        }
        return s;
    }
}

