/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.category.JCRCategory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class CategoryDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = CategoryDAO.class.getName();
    protected AmetysObjectResolver _resolver;
    private CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleCategory"})
    public Map<String, String> createCategory(String parentId, String title, String description, String siteName, String lang) {
        HashMap<String, String> result = new HashMap<String, String>();
        String name = NameHelper.filterName((String)title);
        String realParentId = parentId;
        try {
            JCRCategory parentCategory;
            String templateName;
            if (realParentId.startsWith("provider_")) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(realParentId.substring("provider_".length()));
                realParentId = provider.getRootId(siteName, lang);
            }
            DefaultTraversableAmetysObject parent = (DefaultTraversableAmetysObject)this._resolver.resolveById(realParentId);
            JCRCategory subCategory = (JCRCategory)parent.createChild(name, "ametys:category");
            subCategory.setTitle(title);
            subCategory.setDescription(description);
            if (parent instanceof JCRCategory && (templateName = (parentCategory = (JCRCategory)parent).getTemplate()) != null) {
                subCategory.setTemplate(templateName);
            }
            parent.saveChanges();
            result.put("id", subCategory.getId());
            result.put("parentId", parentId);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Unable to add a new category : the tag category '" + realParentId + "' does not exist anymore", (Throwable)e);
            result.put("message", "unknown-category");
        }
        catch (RepositoryIntegrityViolationException e) {
            this.getLogger().error("Unable to add a new category : a category with name '" + name + "' already exist", (Throwable)e);
            result.put("message", "already-exist");
        }
        return result;
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleCategory"})
    public Map<String, String> editCategory(String id, String title, String description) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            JCRCategory jcrCategory = (JCRCategory)this._resolver.resolveById(id);
            jcrCategory.setTitle(title);
            jcrCategory.setDescription(description);
            jcrCategory.saveChanges();
            result.put("id", jcrCategory.getId());
            result.put("title", title);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Unable to update category : the category '" + id + "' does not exist anymore", (Throwable)e);
            result.put("message", "unknown-category");
        }
        return result;
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleCategory"})
    public Map<String, String> deleteCategory(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            JCRCategory jcrCategory = (JCRCategory)this._resolver.resolveById(id);
            ModifiableAmetysObject parent = (ModifiableAmetysObject)jcrCategory.getParent();
            jcrCategory.remove();
            parent.saveChanges();
            result.put("id", jcrCategory.getId());
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Unable to delete tag category : the category '" + id + "' does not exist anymore", (Throwable)e);
            result.put("message", "unknown-category");
        }
        return result;
    }

    @Callable(rights={"Plugins_Newsletter_Right_AccessNewsletter", "Newsletters_Right_Service_Newsletters"})
    public List<Map<String, Object>> getCategories(List<String> categoryIds) {
        ArrayList<Map<String, Object>> categories = new ArrayList<Map<String, Object>>();
        for (String categoryId : categoryIds) {
            categories.add(this.getCategory(categoryId));
        }
        return categories;
    }

    @Callable(rights={"Plugins_Newsletter_Right_AccessNewsletter"})
    public Map<String, Object> getCategory(String categoryId) {
        for (String providerId : this._categoryProviderEP.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(providerId);
            if (!provider.hasCategory(categoryId)) continue;
            Category category = provider.getCategory(categoryId);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", category.getId());
            infos.put("title", category.getTitle());
            infos.put("description", category.getDescription());
            infos.put("name", category.getName());
            infos.put("template", category.getTemplate());
            infos.put("mode", provider.isWritable() ? "write" : "read");
            infos.put("lang", category.getLang());
            infos.put("siteName", category.getSiteName());
            infos.put("parentId", category.getParentId());
            infos.put("automaticIds", provider.getAutomaticIds(categoryId));
            return infos;
        }
        return null;
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleCategory"})
    public Map<String, Object> applyTemplates(List<String> categoryIds, String template) {
        Set providerIDs = this._categoryProviderEP.getExtensionsIds();
        for (String id : categoryIds) {
            for (String providerID : providerIDs) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(providerID);
                if (!provider.hasCategory(id)) continue;
                Category category = provider.getCategory(id);
                provider.setTemplate(category, template);
            }
        }
        return new HashMap<String, Object>();
    }
}

