<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="contextPath" select="ametys:uriPrefix()"/>
	<xsl:param name="cms-context" select="ametys:siteUriPrefix()"/>
	<xsl:param name="service-title" select="ametys:serviceParameter('header')/text()"/>
	
	<xsl:template match="/Newsletters">
		<html>
			<body>
				<div id="service-newsletter-list">
					
                    <xsl:if test="rss/@url">
                        <div class="rss">
                            <a href="{$contextPath}/{rss/@url}">
                                <img title="NEWSLETTERS_SERVICE_LIST_RSS_FEED_TITLE" alt="NEWSLETTERS_SERVICE_LIST_RSS_FEED_ALT" i18n:attr="title alt" src="{$contextPath}/plugins/web/resources/img/rss/feed.png"/>
                            </a>
                        </div>
                    </xsl:if>
                    
					<!-- Title -->
					<xsl:choose>
						<xsl:when test="$service-title != ''">
							<h1><xsl:value-of select="$service-title"/></h1>
						</xsl:when>
						<xsl:otherwise>
							<h1><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_DESCRIPTION"/></h1>
						</xsl:otherwise>
					</xsl:choose>
					
					<xsl:call-template name="newsletter-list"/>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="newsletter-list">
		<xsl:if test="newsletter">
			<ul>
				<xsl:for-each select="newsletter">
					<li>
						<a href="{$cms-context}/_wrapped-content/{@name}.html" title="{title}"><xsl:value-of select="title"/></a>
						<xsl:text> - </xsl:text>
						<i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="date"/></i18n:date>
						<xsl:if test="number">
							<xsl:text>, N°</xsl:text><xsl:value-of select="number"/>
						</xsl:if>
					</li>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
