/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a newsletters tree. See {@link Ametys.plugins.newsletter.NewslettersTree}
 * @private
 */
Ext.define('Ametys.plugins.newsletter.NewslettersTree.NewsletterNodeEntry', { 
    extend: 'Ext.data.Model',
    
    fields: [
        'id',
        'name',
        {
            name: 'text', mapping: 'title', type: 'string'
        },
        'description',
        'siteName',
        'mode',
        'type',
        'template',
        'automatic',
        {
            name: 'children', 
            depends: ['hasChildren'], 
            calculate: function (data) 
            {
                if (!data.hasChildren)
                {
                    return [];
                }
                return null;
            }
        },
        { name: 'hasChildren', mapping: 'hasChildren', type: 'boolean'},
        {
            name: 'iconCls',
            calculate: function (data)
            {
                if (data.type == 'newsletter' && data.automatic == true)
                {
                    return 'a-tree-glyph ametysicon-envelope14 decorator-ametysicon-gear39';
                }
                else if (data.type == 'newsletter')
                {
                    return 'a-tree-glyph ametysicon-envelope14';
                }
                else if (data.type == 'newsletter-category')
                {
                    return 'a-tree-glyph ametysicon-catalog2';
                }
                else if (data.type == 'newsletter-category-provider')
                {
                    return 'a-tree-glyph ametysicon-categories';
                }
                else
                {
                    return '';
                }
            }
        },
        {
            name: 'tooltipIconCls',
            calculate: function (data)
            {
                if (data.type == 'newsletter' && data.automatic == true)
                {
                    return 'a-tree-glyph ametysicon-envelope14 decorator-ametysicon-gear39';
                }
                else if (data.type == 'newsletter')
                {
                    return 'a-tree-glyph ametysicon-envelope14';
                }
                else if (data.type == 'newsletter-category')
                {
                    return 'a-tree-glyph ametysicon-catalog2';
                }
                else if (data.type == 'newsletter-category-provider')
                {
                    return 'a-tree-glyph ametysicon-categories';
                }
                else
                {
                    return '';
                }
            }
        }
    ]
});