/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.ametys.web.tags.TagExpression;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SitemapCategoryProvider
implements LogEnabled,
CategoryProvider,
Serviceable,
Configurable,
PluginAware {
    public static final String TAG_NAME = "NEWSLETTER_CATEGORY";
    public static final String METADATA_TEMPLATE = "newsletterTemplate";
    public static final String METADATA_AUTOMATIC_IDS = "newsletterAutomaticIds";
    public static final String CATEGORY_PREFIX_ID = "category_";
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected String _pluginName;
    protected String _featureName;
    protected Logger _logger;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = this.configureLabel(configuration);
        this._description = this.configureDescription(configuration);
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public List<Category> getCategories(String siteName, String lang) {
        TagExpression expr = new TagExpression(Expression.Operator.EQ, TAG_NAME);
        String xpathQuery = PageQueryHelper.getPageXPathQuery((String)siteName, (String)lang, (String)"", (Expression)expr, null);
        ArrayList<Category> categories = new ArrayList<Category>();
        AmetysObjectIterable pages = this._resolver.query(xpathQuery);
        for (DefaultPage page : pages) {
            Category category = new Category(CATEGORY_PREFIX_ID + page.getId(), page.getName(), this._id, new I18nizableText(page.getTitle()), null, (String)page.getValue(METADATA_TEMPLATE), siteName, lang);
            categories.add(category);
        }
        return categories;
    }

    @Override
    public Collection<Category> getAllCategories(String siteName, String lang) {
        return this.getCategories(siteName, lang);
    }

    @Override
    public List<Category> getCategories(String categoryID) {
        return new ArrayList<Category>();
    }

    @Override
    public boolean hasCategory(String categoryID) {
        if (categoryID.startsWith(CATEGORY_PREFIX_ID)) {
            String pageID = categoryID.substring(CATEGORY_PREFIX_ID.length());
            try {
                DefaultPage page = (DefaultPage)this._resolver.resolveById(pageID);
                if (page != null) {
                    return page.getTags().contains(TAG_NAME);
                }
            }
            catch (UnknownAmetysObjectException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Category getCategory(String categoryID) {
        String pageID;
        DefaultPage page;
        if (categoryID.startsWith(CATEGORY_PREFIX_ID) && (page = (DefaultPage)this._resolver.resolveById(pageID = categoryID.substring(CATEGORY_PREFIX_ID.length()))) != null && page.getTags().contains(TAG_NAME)) {
            return new Category(CATEGORY_PREFIX_ID + page.getId(), page.getName(), "provider_" + this._id, new I18nizableText(page.getTitle()), new I18nizableText(""), (String)page.getValue(METADATA_TEMPLATE), page.getSiteName(), page.getSitemapName());
        }
        return null;
    }

    @Override
    public void setTemplate(Category category, String templateName) {
        String pageID;
        ModifiablePage page;
        String categoryID = category.getId();
        if (categoryID.startsWith(CATEGORY_PREFIX_ID) && (page = (ModifiablePage)this._resolver.resolveById(pageID = categoryID.substring(CATEGORY_PREFIX_ID.length()))) != null) {
            page.setValue(METADATA_TEMPLATE, (Object)templateName);
            page.saveChanges();
        }
    }

    @Override
    public Collection<String> getAutomaticIds(String categoryId) {
        String pageID;
        Page page;
        if (categoryId.startsWith(CATEGORY_PREFIX_ID) && (page = (Page)this._resolver.resolveById(pageID = categoryId.substring(CATEGORY_PREFIX_ID.length()))) != null) {
            String[] autoIds = (String[])page.getValue(METADATA_AUTOMATIC_IDS, (Object)new String[0]);
            return Arrays.asList(autoIds);
        }
        throw new IllegalArgumentException("The provided category ID is invalid.");
    }

    @Override
    public void setAutomatic(String categoryId, Collection<String> automaticNewsletterIds) {
        String pageID;
        Page page;
        if (categoryId.startsWith(CATEGORY_PREFIX_ID) && (page = (Page)this._resolver.resolveById(pageID = categoryId.substring(CATEGORY_PREFIX_ID.length()))) != null && page instanceof ModifiablePage) {
            ModifiablePage modifiablePage = (ModifiablePage)page;
            String[] autoIdsArray = automaticNewsletterIds.toArray(new String[automaticNewsletterIds.size()]);
            modifiablePage.setValue(METADATA_AUTOMATIC_IDS, (Object)autoIdsArray);
            modifiablePage.saveChanges();
            return;
        }
        throw new IllegalArgumentException("The provided category ID is invalid.");
    }

    @Override
    public AmetysObjectIterable<Content> getNewsletters(String categoryID, String siteName, String lang) {
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.newsletter.Content.newsletter"});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName);
        StringExpression catExpr = new StringExpression("category", Expression.Operator.EQ, categoryID, ExpressionContext.newInstance().withInternal(true));
        AndExpression expr = new AndExpression(new Expression[]{cTypeExpr, siteExpr, catExpr});
        String xpathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr);
        return this._resolver.query(xpathQuery);
    }

    @Override
    public boolean hasChildren(String categoryID) {
        return false;
    }

    @Override
    public boolean hasNewsletters(String categoryID, String siteName, String lang) {
        ContentTypeExpression expr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.newsletter.Content.newsletter"});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName);
        expr = new AndExpression(new Expression[]{expr, siteExpr});
        StringExpression catExpr = new StringExpression("category", Expression.Operator.EQ, categoryID, ExpressionContext.newInstance().withInternal(true));
        expr = new AndExpression(new Expression[]{expr, catExpr});
        String xpathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr);
        return this._resolver.query(xpathQuery).iterator().hasNext();
    }

    protected I18nizableText configureLabel(Configuration configuration) throws ConfigurationException {
        Configuration labelConfiguration = configuration.getChild("label");
        if (labelConfiguration.getAttributeAsBoolean("i18n", false)) {
            return new I18nizableText("plugin." + this._pluginName, labelConfiguration.getValue(""));
        }
        return new I18nizableText(labelConfiguration.getValue(""));
    }

    protected I18nizableText configureDescription(Configuration configuration) throws ConfigurationException {
        Configuration descConfiguration = configuration.getChild("description");
        if (descConfiguration.getAttributeAsBoolean("i18n", false)) {
            return new I18nizableText("plugin." + this._pluginName, descConfiguration.getValue(""));
        }
        return new I18nizableText(descConfiguration.getValue(""));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public String getRootId(String siteName, String lang) {
        return this._id;
    }
}

