/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.workflow;

import com.opensymphony.workflow.WorkflowException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletterFilterResult;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.web.repository.site.Site;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.ContentHandlerProxy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CreateNewsletterFunction
extends CreateContentFunction
implements Initializable,
Contextualizable {
    public static final String NEWSLETTER_CATEGORY_KEY = CreateNewsletterFunction.class.getName() + "$category";
    public static final String NEWSLETTER_NUMBER_KEY = CreateNewsletterFunction.class.getName() + "$number";
    public static final String NEWSLETTER_DATE_KEY = CreateNewsletterFunction.class.getName() + "$date";
    public static final String NEWSLETTER_IS_AUTOMATIC_KEY = CreateNewsletterFunction.class.getName() + "$isAutomatic";
    public static final String NEWSLETTER_PROCESS_AUTO_SECTIONS_KEY = CreateNewsletterFunction.class.getName() + "$processAutoSections";
    public static final String NEWSLETTER_CONTENT_ID_MAP_KEY = CreateNewsletterFunction.class.getName() + "$contentIds";
    public static final DateFormat NEWSLETTER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    protected static final Set<String> _IGNORE_ATTRS = new HashSet<String>();
    protected static final String _DEFAULT_LEVEL = "3";
    protected Context _context;
    private SourceResolver _sourceResolver;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private TransformerFactory _transformerFactory;
    private Properties _transformerProperties;
    private SAXParserFactory _saxParserFactory;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    public void initialize() throws Exception {
        this._transformerFactory = TransformerFactory.newInstance();
        this._transformerProperties = new Properties();
        this._transformerProperties.put("method", "xml");
        this._transformerProperties.put("encoding", "UTF-8");
        this._transformerProperties.put("omit-xml-declaration", "yes");
        this._saxParserFactory = SAXParserFactory.newInstance();
        this._saxParserFactory.setNamespaceAware(true);
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_CREATE_NEWSLETTER_FUNCTION_LABEL");
    }

    protected void _populateContent(Map transientVars, ModifiableContent content) throws WorkflowException {
        super._populateContent(transientVars, content);
        String category = (String)transientVars.get(NEWSLETTER_CATEGORY_KEY);
        if (category == null) {
            throw new WorkflowException("Missing category");
        }
        Long number = (Long)transientVars.get(NEWSLETTER_NUMBER_KEY);
        Date date = (Date)transientVars.get(NEWSLETTER_DATE_KEY);
        boolean isAutomatic = "true".equals(transientVars.get(NEWSLETTER_IS_AUTOMATIC_KEY));
        boolean processAutoSections = "true".equals(transientVars.get(NEWSLETTER_PROCESS_AUTO_SECTIONS_KEY));
        Map filterResults = (Map)transientVars.get(NEWSLETTER_CONTENT_ID_MAP_KEY);
        if (processAutoSections && filterResults == null) {
            throw new WorkflowException("Content ID map must not be null if processing automatic sections.");
        }
        ModifiableModelLessDataHolder internalDataHolder = content.getInternalDataHolder();
        internalDataHolder.setValue("category", (Object)category);
        internalDataHolder.setValue("automatic", (Object)isAutomatic);
        if (number != null) {
            content.setValue("newsletter-number", (Object)number);
        }
        if (date != null) {
            content.setValue("newsletter-date", (Object)DateUtils.asLocalDate((Date)date));
        }
        String siteName = (String)transientVars.get(SITE_KEY);
        Site site = this._siteManager.getSite(siteName);
        this._initContentRichText(content, site.getSkinId(), category, processAutoSections, filterResults);
    }

    private void _initContentRichText(ModifiableContent content, String skinId, String categoryID, boolean processAutoSections, Map<String, AutomaticNewsletterFilterResult> filterResults) throws WorkflowException {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String id : ids) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            if (!provider.hasCategory(categoryID)) continue;
            Category category = provider.getCategory(categoryID);
            String templateId = category.getTemplate();
            if (templateId == null) {
                throw new WorkflowException("The template can not be null");
            }
            try {
                String text = this._getContent(skinId, templateId);
                String processedText = this._processAutoTags(text, processAutoSections, filterResults);
                ElementType richTextType = ((ElementDefinition)content.getDefinition("content")).getType();
                DataContext dataContext = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)content).withDataPath("content");
                content.setValue("content", richTextType.fromJSONForClient((Object)processedText, dataContext));
                content.saveChanges();
            }
            catch (IOException e) {
                throw new WorkflowException("Unable to transform rich text", (Throwable)e);
            }
        }
    }

    private String _processAutoTags(String text, boolean processAutoSections, Map<String, AutomaticNewsletterFilterResult> filterResults) throws WorkflowException {
        StringReader in = new StringReader(text);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            Transformer transformer = this._transformerFactory.newTransformer();
            transformer.setOutputProperties(this._transformerProperties);
            XMLReader xmlReader = this._saxParserFactory.newSAXParser().getXMLReader();
            NewsletterFilter newsletterFilter = new NewsletterFilter(xmlReader, this._sourceResolver, processAutoSections, filterResults);
            SAXSource transformSource = new SAXSource(newsletterFilter, new InputSource(in));
            transformer.transform(transformSource, new StreamResult(baos));
            return baos.toString("UTF-8");
        }
        catch (TransformerException e) {
            throw new WorkflowException("Transformer exception.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WorkflowException("SAX exception.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new WorkflowException("SAX exception.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new WorkflowException("Unsupported encoding.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getContent(String skinId, String templateId) throws IOException, WorkflowException {
        String string;
        SitemapSource src = null;
        Request request = ContextHelper.getRequest((Context)this._context);
        if (request == null) {
            throw new WorkflowException("Unable to get the request");
        }
        try {
            request.setAttribute("skin", (Object)skinId);
            src = (SitemapSource)this._sourceResolver.resolveURI("cocoon://_plugins/newsletter/" + templateId + "/model.xml");
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            this._sourceResolver.release(src);
            throw throwable;
        }
        this._sourceResolver.release((Source)src);
        return string;
    }

    static {
        _IGNORE_ATTRS.add("auto-newsletter-ignore");
        _IGNORE_ATTRS.add("auto-newsletter-ignore-if-empty");
        _IGNORE_ATTRS.add("auto-newsletter-insert-filter");
        _IGNORE_ATTRS.add("auto-newsletter-insert-level");
    }

    protected class NewsletterFilter
    extends XMLFilterImpl {
        private SourceResolver _srcResolver;
        private boolean _processAutoSections;
        private Map<String, AutomaticNewsletterFilterResult> _filterResults;
        private boolean _ignore;
        private boolean _ignoreNextLevel;
        private int _ignoreDepth;

        public NewsletterFilter(XMLReader xmlReader, SourceResolver sourceResolver, boolean processAutoSections, Map<String, AutomaticNewsletterFilterResult> filterResults) {
            super(xmlReader);
            this._srcResolver = sourceResolver;
            this._processAutoSections = processAutoSections;
            this._filterResults = filterResults;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this._ignore = false;
            this._ignoreDepth = 0;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String ignore = atts.getValue("auto-newsletter-ignore");
            String ignoreIfEmpty = atts.getValue("auto-newsletter-ignore-if-empty");
            String insertFilter = atts.getValue("auto-newsletter-insert-filter");
            String insertFilterLevel = atts.getValue("auto-newsletter-insert-level");
            if (this._ignoreNextLevel) {
                this._ignoreNextLevel = false;
                this._ignore = true;
                this._ignoreDepth = 0;
            }
            if (StringUtils.isNotEmpty((CharSequence)ignore) || StringUtils.isNotEmpty((CharSequence)ignoreIfEmpty) || StringUtils.isNotEmpty((CharSequence)insertFilter) || StringUtils.isNotEmpty((CharSequence)insertFilterLevel)) {
                AttributesImpl newAtts = new AttributesImpl();
                this._copyStartElementAttributes(atts, newAtts);
                SaxBuffer saxBuffer = null;
                if (this._processAutoSections && !this._ignore) {
                    if ("true".equals(ignore)) {
                        this._ignore = true;
                        this._ignoreDepth = 0;
                    } else if (StringUtils.isNotEmpty((CharSequence)ignoreIfEmpty)) {
                        this._handleIgnoreIfEmpty(ignoreIfEmpty);
                    } else if (StringUtils.isNotEmpty((CharSequence)insertFilter)) {
                        saxBuffer = this._handleInsertFilter(insertFilter, insertFilterLevel, saxBuffer);
                    }
                }
                if (!this._ignore) {
                    super.startElement(uri, localName, qName, (Attributes)newAtts);
                    if (saxBuffer != null) {
                        this._ignoreNextLevel = true;
                        saxBuffer.toSAX(this.getContentHandler());
                    }
                } else {
                    ++this._ignoreDepth;
                }
            } else if (!this._ignore) {
                super.startElement(uri, localName, qName, atts);
            } else {
                ++this._ignoreDepth;
            }
        }

        private void _handleIgnoreIfEmpty(String ignoreIfEmpty) {
            if (!this._filterResults.containsKey(ignoreIfEmpty) || !this._filterResults.get(ignoreIfEmpty).hasResults()) {
                this._ignore = true;
                this._ignoreDepth = 0;
            }
        }

        private SaxBuffer _handleInsertFilter(String insertFilter, String insertFilterLevel, SaxBuffer saxBuffer) throws SAXException {
            SaxBuffer modifiedSaxBuffer = saxBuffer;
            if (this._filterResults.containsKey(insertFilter) && this._filterResults.get(insertFilter).hasResults()) {
                AutomaticNewsletterFilterResult result = this._filterResults.get(insertFilter);
                List<String> contentIds = result.getContentIds();
                String viewName = result.getViewName();
                String level = (String)StringUtils.defaultIfEmpty((CharSequence)insertFilterLevel, (CharSequence)CreateNewsletterFunction._DEFAULT_LEVEL);
                modifiedSaxBuffer = this._getFilterContent(contentIds, level, viewName);
            } else {
                this._ignore = true;
                this._ignoreDepth = 0;
            }
            return modifiedSaxBuffer;
        }

        private void _copyStartElementAttributes(Attributes atts, AttributesImpl newAtts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attrName = atts.getLocalName(i);
                if (_IGNORE_ATTRS.contains(attrName)) continue;
                newAtts.addAttribute(atts.getURI(i), attrName, atts.getQName(i), atts.getType(i), atts.getValue(i));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._ignoreNextLevel) {
                this._ignoreNextLevel = false;
            }
            if (!this._ignore) {
                super.endElement(uri, localName, qName);
            } else {
                --this._ignoreDepth;
                if (this._ignoreDepth < 1) {
                    this._ignore = false;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this._ignore && !this._ignoreNextLevel) {
                super.characters(ch, start, length);
            }
        }

        private SaxBuffer _getFilterContent(List<String> contentIds, String level, String viewName) throws SAXException {
            SaxBuffer saxBuffer;
            SitemapSource src = null;
            Request request = ContextHelper.getRequest((Context)CreateNewsletterFunction.this._context);
            if (request == null) {
                throw new SAXException("Unable to get the request");
            }
            try {
                StringBuilder url = new StringBuilder("cocoon://_plugins/web/contents/last-published");
                url.append("?viewName=").append(viewName).append("&level=").append(level);
                for (String id : contentIds) {
                    url.append("&contentId=").append(id);
                }
                src = (SitemapSource)this._srcResolver.resolveURI(url.toString());
                SaxBuffer buffer = new SaxBuffer();
                src.toSAX((ContentHandler)((Object)new IgnoreRootTagHandler(CreateNewsletterFunction.this, (ContentHandler)buffer)));
                saxBuffer = buffer;
            }
            catch (IOException e) {
                try {
                    throw new SAXException("Error resolving the contents.", e);
                }
                catch (Throwable throwable) {
                    this._srcResolver.release(src);
                    throw throwable;
                }
            }
            this._srcResolver.release((Source)src);
            return saxBuffer;
        }
    }

    protected class IgnoreRootTagHandler
    extends ContentHandlerProxy {
        private int _depth;

        public IgnoreRootTagHandler(CreateNewsletterFunction this$0, ContentHandler contentHandler) {
            super(contentHandler);
        }

        public void startDocument() throws SAXException {
            this._depth = 0;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            ++this._depth;
            if (this._depth > 1) {
                super.startElement(uri, loc, raw, a);
            }
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            if (this._depth > 1) {
                super.endElement(uri, loc, raw);
            }
            --this._depth;
        }
    }
}

