/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button enabled if at least one newsletter category is on the current selection.
 * @private
 */
Ext.define('Ametys.plugins.newsletter.controller.TemplateMenuController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	/**
	 * @property {String[]} [_categoryIds=[]] List of identifiers of categories concerned by the action of the controller
	 * @private
	 */
	
	constructor: function(config)
	{
		this.callParent(arguments);
		
		this._categoryIds = [];
		
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
	},
	
	/**
	 * Listener when the category has changed.
	 * Will update the available items upon the current selection.
	 * @param {Ametys.message.Message} message The modified message.
	 * @protected
	 */
	_onModified: function (message)
	{
		if (this.updateTargetsInCurrentSelectionTargets(message))
		{
			this.refresh();
		}
	},
	
	updateState: function()
	{
		this._getStatus(this.getMatchingTargets());
	},
	
	/**
	 * Get the lock state of given targets
	 * @param targets The category targets
	 * @private
	 */
	_getStatus: function (targets)
	{
		this.disable();
		
		var categoryIds = [];
		for (var i=0; i < targets.length; i++)
		{
			categoryIds.push(targets[i].getParameters().id);
		}

		this.serverCall ('getStatus', [categoryIds], this._getStatusCb, { errorMessage: true, refreshing: true });
	},
	
	/**
	 * @private
	 * Callback function called after retrieving the status of category targets
	 * @param params The JSON result 
	 */
	_getStatusCb: function (params)
	{
		var categories = params['categories'];
		this._categoryIds = [];
		
		var atLeastOneTemplateCategory = false;
		
		this._getGalleries().each(function (gallery) {
            gallery.items.each(function(item) {
				var elmt = Ametys.ribbon.RibbonManager.getUI(item.controlId);
				
				item.setVisible(true);
				
				var toggleTemplate = false;
				Ext.Array.each (categories, function (category) {
					if (category.template == elmt.name)
					{
						toggleTemplate = true;
						atLeastOneTemplateCategory = true;
					}
				});
				
				item.toggle(toggleTemplate, true);
            });
		});
		
		this.toggle (atLeastOneTemplateCategory);
		
		if (categories.length > 0)
		{
			for (var i=0; i < categories.length; i++)
			{
				this._categoryIds.push(categories[i].id)
			}
			this.enable();
		}
		else
		{
			this.disable();
		}
	}
	
});