/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.generators;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryGenerator;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.web.WebConstants;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.page.ZoneItemException;
import org.ametys.web.site.SiteConfigurationExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NewsletterServiceGenerator
extends CategoryGenerator {
    protected SiteConfigurationExtensionPoint _siteConfiguration;
    protected UserManager _userManager;
    protected UserHelper _userHelper;
    protected PageHelper _pageHelper;
    protected CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._siteConfiguration = (SiteConfigurationExtensionPoint)smanager.lookup(SiteConfigurationExtensionPoint.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._pageHelper = (PageHelper)smanager.lookup(PageHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        String[] ids;
        String email;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"NewsletterService");
        if (zoneItem != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Categories");
            String[] categoryIDs = ((String)zoneItem.getServiceParameters().getValue("categories", false, (Object)"")).split(",");
            Set ids2 = this._categoryProviderEP.getExtensionsIds();
            for (String categoryID : categoryIDs) {
                boolean found = false;
                for (String id : ids2) {
                    CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                    if (!provider.hasCategory(categoryID)) continue;
                    Category category = provider.getCategory(categoryID);
                    this.saxCategory(provider, category, true, false);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ZoneItemException("The newsletter category with id '" + categoryID + "' was not found");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Categories");
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"FormResult");
        String msg = this.parameters.getParameter("msg", "");
        if (msg.length() != 0) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"msg", (String)msg);
        }
        if ((email = this.parameters.getParameter("email", "")).length() != 0) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"email", (String)email);
        }
        for (String id : ids = this.parameters.getParameter("subscribeTo", "").split(",")) {
            if (id.length() <= 0) continue;
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"subscribeTo", (String)id);
        }
        for (String id : ids = this.parameters.getParameter("alreadySubscribeTo", "").split(",")) {
            if (id.length() <= 0) continue;
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"alreadySubscribeTo", (String)id);
        }
        Page page = (Page)request.getAttribute(Page.class.getName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"has-captcha", (String)String.valueOf(this._pageHelper.isCaptchaRequired((SitemapElement)page)));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"FormResult");
        this._saxInfoUser();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"NewsletterService");
        this.contentHandler.endDocument();
    }

    private void _saxInfoUser() throws SAXException {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        if (userIdentity != null) {
            User user = this._userManager.getUser(userIdentity);
            this._userHelper.saxUser(user, this.contentHandler);
        }
    }
}

