/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;

public class ImportSubscribersAction
extends ServiceableAction {
    private static final String[] _ALLOWED_EXTENSIONS = new String[]{"txt", "csv"};
    private static final Pattern __EMAIL_VALIDATOR = SendMailHelper.EMAIL_VALIDATION;
    protected SubscribersDAO _subscribersDao;
    protected CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscribersDao = (SubscribersDAO)((Object)smanager.lookup(SubscribersDAO.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String filename;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = parameters.getParameter("siteName", request.getParameter("siteName"));
        String categoryId = request.getParameter("categoryId");
        boolean cleanTable = "true".equals(request.getParameter("cleanSubscribers"));
        Part part = (Part)request.get("importFile");
        if (part instanceof RejectedPart) {
            request.setAttribute(JSonReader.OBJECT_TO_READ, Map.of("success", false, "error", "rejected-file"));
            return EMPTY_MAP;
        }
        PartOnDisk uploadedFilePart = (PartOnDisk)part;
        File uploadedFile = uploadedFilePart != null ? uploadedFilePart.getFile() : null;
        String string = filename = uploadedFilePart != null ? uploadedFilePart.getFileName().toLowerCase() : null;
        if (!FilenameUtils.isExtension((String)filename, (String[])_ALLOWED_EXTENSIONS)) {
            request.setAttribute(JSonReader.OBJECT_TO_READ, Map.of("success", false, "error", "invalid-extension"));
            return EMPTY_MAP;
        }
        Category category = this._categoryProviderEP.getCategory(categoryId);
        if (category == null) {
            request.setAttribute(JSonReader.OBJECT_TO_READ, Map.of("success", false, "error", "unknown-category"));
            return EMPTY_MAP;
        }
        FileInputStream fileIS = new FileInputStream(uploadedFile);
        BOMInputStream bomIS = new BOMInputStream((InputStream)fileIS);
        Collection<String> emails = this.getEmails(bomIS);
        if (!emails.isEmpty()) {
            if (cleanTable) {
                this._subscribersDao.empty(categoryId, siteName);
            }
            this.insertSubscribers(emails, categoryId, siteName, result);
        }
        result.put("success", true);
        result.put("categoryId", categoryId);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Collection<String> getEmails(BOMInputStream bomIS) throws IOException {
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        for (String line : IOUtils.readLines((InputStream)bomIS, (Charset)StandardCharsets.UTF_8)) {
            String[] part = line.split(";");
            String email = StringUtils.trimToEmpty((String)part[0]);
            if (!__EMAIL_VALIDATOR.matcher(email.toLowerCase()).matches() || !StringUtils.isNotBlank((CharSequence)email)) continue;
            emails.add(email);
        }
        return emails;
    }

    protected void insertSubscribers(Collection<String> emails, String categoryId, String siteName, Map<String, Object> result) {
        int subscribedCount = 0;
        int existingCount = 0;
        int errorCount = 0;
        for (String email : emails) {
            try {
                if (this._subscribersDao.getSubscriber(email, siteName, categoryId) == null) {
                    Subscriber subscriber = new Subscriber();
                    subscriber.setEmail(email);
                    subscriber.setSiteName(siteName);
                    subscriber.setCategoryId(categoryId);
                    subscriber.setSubscribedAt(new Date());
                    String token = UUID.randomUUID().toString();
                    subscriber.setToken(token);
                    this._subscribersDao.subscribe(subscriber);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("The user with email '" + email + "' subscribed to the newsletter with the token " + token);
                    }
                    ++subscribedCount;
                    continue;
                }
                ++existingCount;
            }
            catch (Exception e) {
                this.getLogger().error("Impossible to add as a subscriber the email " + email + " in category " + categoryId + " of site " + siteName, (Throwable)e);
                ++errorCount;
            }
        }
        result.put("subscribedCount", Integer.toString(subscribedCount));
        result.put("existingCount", Integer.toString(existingCount));
        result.put("errorCount", Integer.toString(errorCount));
    }
}

