/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.subscribe.AbstractSubscribeAction;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class SubscribeAction
extends AbstractSubscribeAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        boolean subscribe = request.getParameter("subscribe") != null;
        String email = request.getParameter("email");
        result.put("email", email);
        ZoneItem currentZoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        String zoneItemId = request.getParameter("zoneitem-id");
        if (subscribe && (zoneItemId == null || currentZoneItem.getId().equals(zoneItemId))) {
            try {
                String siteName = request.getParameter("siteName");
                String[] categories = request.getParameterValues("category");
                if (!this._validEmail(email)) {
                    result.put("msg", "invalid-email");
                    return result;
                }
                SitemapElement sitemapElement = currentZoneItem == null ? (SitemapElement)this._resolver.resolveById(request.getParameter("page-id")) : currentZoneItem.getZone().getSitemapElement();
                if (!this._validCaptcha(request, sitemapElement)) {
                    result.put("msg", "invalid-captcha");
                    return result;
                }
                if (!this._validCategory(categories)) {
                    result.put("msg", "invalid-category");
                    return result;
                }
                ArrayList<String> subscribeTo = new ArrayList<String>();
                ArrayList<String> alreadySubscribeTo = new ArrayList<String>();
                for (String categoryID : categories) {
                    if (this._subscribersDao.getSubscriber(email, siteName, categoryID) == null) {
                        Category category = this._getCategory(categoryID);
                        if (category == null) continue;
                        Subscriber subscriber = this._createSubscritpion(email, siteName, categoryID);
                        this._subscribersDao.subscribe(subscriber);
                        this.getLogger().info("The user with email '" + email + "' subscribed to the newsletter with the token " + subscriber.getToken());
                        subscribeTo.add(categoryID);
                        continue;
                    }
                    alreadySubscribeTo.add(categoryID);
                }
                result.put("msg", "success");
                result.put("subscribeTo", String.join((CharSequence)",", subscribeTo));
                result.put("alreadySubscribeTo", String.join((CharSequence)",", alreadySubscribeTo));
            }
            catch (Exception e) {
                result.put("msg", "failure");
                this.getLogger().error("An error occurred during the subscription for the email '" + email + "'", (Throwable)e);
            }
        }
        return result;
    }

    protected boolean _validCategory(String[] categories) {
        return categories != null && categories.length > 0;
    }
}

