/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.nextcloud;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.extrausermgt.oauth.OAuthProvider;
import org.ametys.plugins.extrausermgt.oauth.OauthProviderExtensionPoint;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NextcloudExplorerGenerator
extends AbstractGenerator
implements Serviceable,
Initializable {
    private String _remoteUrl;
    private OauthProviderExtensionPoint _oauthEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._oauthEP = (OauthProviderExtensionPoint)manager.lookup(OauthProviderExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._remoteUrl = (String)Config.getInstance().getValue("nextcloud.remote.url");
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        OAuthProvider nextcloudProvider = (OAuthProvider)this._oauthEP.getExtension("nextcloud");
        Optional accessToken = nextcloudProvider.getStoredAccessToken();
        Optional userId = nextcloudProvider.getStoredCustomParameter("user_id");
        if (accessToken.isEmpty() || userId.isEmpty()) {
            this.contentHandler.startDocument();
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"not-connected");
            this.contentHandler.endDocument();
            return;
        }
        SardineImpl webDavClient = new SardineImpl(((AccessToken)accessToken.get()).getValue());
        this.contentHandler.startDocument();
        this.saxRemoteFolder("/remote.php/dav/files/" + (String)userId.get() + "/", (Sardine)webDavClient);
        this.contentHandler.endDocument();
    }

    private void saxRemoteFolder(String path, Sardine davClient) throws ProcessingException, SAXException {
        try {
            List resources = davClient.list(this._remoteUrl + path);
            DavResource target = null;
            Iterator iterator = resources.iterator();
            while (iterator.hasNext() && target == null) {
                DavResource resource = (DavResource)iterator.next();
                if (!StringUtils.equals((CharSequence)resource.getPath(), (CharSequence)path)) continue;
                resources.remove(resource);
                target = resource;
            }
            if (target == null) {
                throw new ProcessingException("Failed to retrieve information for remote folder at path " + path);
            }
            this.saxDirectory(target, resources, davClient);
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to list content of remote folder '" + path + "'", (Throwable)e);
        }
    }

    private void saxDirectory(DavResource directory, List<DavResource> children, Sardine davClient) throws SAXException, ProcessingException {
        AttributesImpl childAtts = new AttributesImpl();
        childAtts.addCDATAAttribute("name", directory.getName());
        childAtts.addCDATAAttribute("path", directory.getPath());
        childAtts.addCDATAAttribute("type", "collection");
        boolean hasResources = false;
        boolean hasChildNodes = false;
        Iterator<DavResource> iterator = children.iterator();
        while (!(!iterator.hasNext() || hasChildNodes && hasResources)) {
            DavResource davResource = iterator.next();
            if (davResource.isDirectory()) {
                hasChildNodes = true;
                continue;
            }
            hasResources = true;
        }
        if (hasChildNodes) {
            childAtts.addCDATAAttribute("hasChildNodes", "true");
        }
        if (hasResources) {
            childAtts.addCDATAAttribute("hasResources", "true");
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
        for (DavResource child : children) {
            if (child.isDirectory()) {
                this.saxRemoteFolder(child.getPath(), davClient);
                continue;
            }
            this.saxResource(child);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Node");
    }

    private void saxResource(DavResource resource) throws SAXException {
        AttributesImpl childAtts = new AttributesImpl();
        childAtts.addCDATAAttribute("href", this._remoteUrl + resource.getHref().toString());
        childAtts.addCDATAAttribute("name", resource.getName());
        childAtts.addCDATAAttribute("mimetype", resource.getContentType());
        childAtts.addCDATAAttribute("lastModified", DateUtils.dateToString((Date)resource.getModified()));
        childAtts.addCDATAAttribute("size", String.valueOf(resource.getContentLength()));
        childAtts.addCDATAAttribute("type", "resource");
        childAtts.addCDATAAttribute("path", resource.getPath());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
    }
}

